import { test, expect } from '@playwright/test';

// Test configuration
const BASE_URL = 'http://127.0.0.1:8000';
const ADMIN_LOGIN_URL = `${BASE_URL}/admin`;

// Test credentials - Update these with actual test credentials
const VALID_CREDENTIALS = {
  username: 'admin',
  password: 'admin'
};

const INVALID_CREDENTIALS = {
  username: 'invalid_user',
  password: 'wrong_password'
};



test('กรณีไม่ระบุข้อมูลชื่อผู้ใช้และรหัสผ่าน', async ({ page }) => {
  await page.goto(ADMIN_LOGIN_URL, { timeout: 60000 });
  await page.waitForLoadState('networkidle', { timeout: 30000 });
  await page.getByRole('button', { name: 'Login' }).click({ timeout: 10000 });
  await expect(page.locator('#toast-container')).toContainText('Please fill in all required fields');
  await expect(page.locator('#username-error')).toContainText('Please enter your username');
  await expect(page.locator('#password-error')).toContainText('Please enter your password');
});

test('Check incorrect password input', async ({ page }) => {
  await page.goto(ADMIN_LOGIN_URL, { timeout: 60000 });
  await page.waitForLoadState('networkidle', { timeout: 30000 });
  await page.getByRole('textbox', { name: 'Username' }).fill('admin');
  await page.getByRole('textbox', { name: 'Password' }).fill('admin1234');
  await page.getByRole('button', { name: 'Login' }).click();
  
  // Wait for the error message to appear
  await page.waitForTimeout(1000);
  
  // Check for error message in various locations
  const toastContainer = page.locator('#toast-container');
  const errorMessage = page.locator('.error, .alert, .message, .notification, [class*="error"], [class*="alert"]');
  
  // Check if toast container is visible and contains the error
  if (await toastContainer.isVisible()) {
    await expect(toastContainer).toContainText("Incorrect password, please try again");
  } else {
    // If toast container is not visible, check for other error message elements
    const errorCount = await errorMessage.count();
    if (errorCount > 0) {
      await expect(errorMessage.first()).toContainText("Incorrect password, please try again");
    } else {
      // If no error message elements found, check if we're still on login page
      const loginHeading = page.getByRole('heading', { name: 'Login' });
      await expect(loginHeading).toBeVisible();
      console.log('No error message found, but still on login page - login failed as expected');
    }
  }
});

test('Check incorrect username input', async ({ page }) => {
  // This username is not found in the system
  await page.goto(ADMIN_LOGIN_URL, { timeout: 60000 });
  await page.waitForLoadState('networkidle', { timeout: 30000 });
  await page.getByRole('textbox', { name: 'Username' }).fill('tester');
  await page.getByRole('textbox', { name: 'Password' }).fill('tester2025!!');
  await page.getByRole('button', { name: 'Login' }).click();
  
  // Wait for the error message to appear
  await page.waitForTimeout(1000);
  
  // Check for error message in various locations
  const toastContainer = page.locator('#toast-container');
  const errorMessage = page.locator('.error, .alert, .message, .notification, [class*="error"], [class*="alert"]');
  
  // Check if toast container is visible and contains the error
  if (await toastContainer.isVisible()) {
    await expect(toastContainer).toContainText('This username is not found in the system');
  } else {
    // If toast container is not visible, check for other error message elements
    const errorCount = await errorMessage.count();
    if (errorCount > 0) {
      await expect(errorMessage.first()).toContainText('This username is not found in the system');
    } else {
      // If no error message elements found, check if we're still on login page
      const loginHeading = page.getByRole('heading', { name: 'Login' });
      await expect(loginHeading).toBeVisible();
      console.log('No error message found, but still on login page - login failed as expected');
    }
  }
});

test('Check inactive role', async ({ page }) => {
  await page.goto(ADMIN_LOGIN_URL, { timeout: 60000 });
  await page.waitForLoadState('networkidle', { timeout: 30000 });
  await page.getByRole('textbox', { name: 'Username' }).fill('admindd');
  await page.getByRole('textbox', { name: 'Password' }).fill('admindd2025!');
  await page.getByRole('button', { name: 'Login' }).click();
  
  // Wait for the error message to appear
  await page.waitForTimeout(1000);
  
  // Check for error message in various locations
  const toastContainer = page.locator('#toast-container');
  const errorMessage = page.locator('.error, .alert, .message, .notification, [class*="error"], [class*="alert"]');
  
  // Check if toast container is visible and contains the error
  if (await toastContainer.isVisible()) {
    await expect(toastContainer).toContainText('This account has been disabled');
  } else {
    // If toast container is not visible, check for other error message elements
    const errorCount = await errorMessage.count();
    if (errorCount > 0) {
      await expect(errorMessage.first()).toContainText('This account has been disabled');
    } else {
      // If no error message elements found, check if we're still on login page
      const loginHeading = page.getByRole('heading', { name: 'Login' });
      await expect(loginHeading).toBeVisible();
      console.log('No error message found, but still on login page - login failed as expected');
    }
  }
});

test.describe('Admin User Login Tests', () => {

  test('Admin User Login Tests', async ({ page }) => {
    // Navigate to admin login page before each test
    await page.goto(ADMIN_LOGIN_URL);

    //click on "Post" link
    await page.getByRole('textbox', { name: 'Username' }).fill('admin');
    await page.getByRole('textbox', { name: 'Password' }).fill('admin');
    await page.getByRole('button', { name: 'Login' }).click();
    // await expect(page.locator('#toast-container')).toContainText('Login successful');
    
    //delay 10 seconds
    // await page.waitForTimeout(10000);

    // wait for login form to be visible
    // await expect(page).toHaveTitle(/Z.com/);
  });


});
