import { test, expect } from '@playwright/test';

test('เพิ่มข้อมูลผู้ใช้งาน', async ({ page }) => {
  try {
    // Navigate to the user list page with increased timeout
    await page.goto('http://127.0.0.1:8000/admin/user/list', { timeout: 60000 });

    // Wait for login form to be visible
    await page.waitForSelector('input[name="username"]', { timeout: 30000 });

    // Login form (if redirected to login)
    await page.getByRole('textbox', { name: 'Username' }).fill('admin');
    await page.getByRole('textbox', { name: 'Password' }).fill('admin');
    await page.getByRole('button', { name: 'Login' }).click();
    
    // Wait for login to complete
    await page.waitForLoadState('networkidle', { timeout: 30000 });
  } catch (error) {
    console.error('Login failed:', error);
    throw error;
  }

  // Navigate to Add User form
  await page.getByRole('link', { name: ' Add' }).click();

  // Fill the Add User form
  await page.getByRole('textbox', { name: 'Please specify Name' }).fill('Test User');
  await page.getByRole('textbox', { name: 'Please specify Username' }).fill('testuser');
  await page.getByRole('textbox', { name: 'Please specify Email' }).fill('test@example.com');
  await page.getByRole('textbox', { name: 'Please specify Password' }).fill('password123');
  await page.getByRole('textbox', { name: 'Please specify Confirm' }).fill('password123');

  // Select role from dropdown
  await page.getByRole('combobox', { name: 'Please select Role' }).click();
  await page.getByRole('option', { name: 'General Admin' }).click();

  // Cancel to go back to list
  await page.getByRole('link', { name: 'Cancel' }).click();

  // Take screenshot
  await page.screenshot({ fullPage: true, path: 'user-list-page.png' });
});