import { test, expect } from '@playwright/test';

test.describe('Contact Info Tests', () => {

  const BASE_URL = process.env.BASE_URL || 'http://127.0.0.1:8000';


  async function login(page) {
    await page.goto(`${BASE_URL}/admin`);
    await page.getByRole('textbox', { name: 'Username' }).fill('admin');
    await page.getByRole('textbox', { name: 'Password' }).fill('admin');
    await page.getByRole('button', { name: 'Login' }).click();
  }

  async function ContactSocial(page) {
    await page.getByRole('link', { name: '󰛋 Contact 󰅂' }).click();
    await page.getByRole('link', { name: 'detail' }).click();
    await page.getByRole('link', { name: 'Social Media' }).click();
    await page.waitForLoadState('networkidle');
  }

  async function ContactInformation(page) {
    await page.getByRole('link', { name: '󰛋 Contact 󰅂' }).click();
    await page.getByRole('link', { name: 'detail' }).click();
    await page.waitForLoadState('networkidle');
  }

  async function Contacts(page) {
    await page.getByRole('link', { name: '󰛋 Contact 󰅂' }).click();
    await page.getByRole('link', { name: 'detail' }).click();
    await page.getByRole('link', { name: 'Contact', exact: true }).click();
    await page.waitForLoadState('networkidle');
  }

 

  test.beforeEach(async ({ page }) => {
    // Login to admin panel
    await login(page);
  });

  // เพิ่ม link โดยเพิ่ม https:// หรือ http:// 
  test('เพิ่ม link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Line');

    await page.locator('#line-url').fill('https://line.me/ti/p/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม link โดยเพิ่ม https:// หรือ http:// 
  test('เพิ่ม link โดยเพิ่ม http://', async ({ page }) => {
     await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Line');

    await page.locator('#line-url').fill('http://line.me/ti/p/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  // เพิ่ม link โดยไม่เพิ่ม https:// หรือ http: 
  test('เพิ่ม link โดยไม่เพิ่ม https:// หรือ http:', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Line');

    await page.locator('#line-url').fill('www.line.me/ti/p/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });


  // แก้ไข Link Line
  test('แก้ไข Link Line', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Line');

    await page.locator('#line-url').fill('https://line.me/ti/p/test123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ Link  Line
  test('ลบ Link Line', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Line');

    await page.locator('#line-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== FACEBOOK TESTS ==========
  // เพิ่ม Facebook link โดยเพิ่ม https://
  test('เพิ่ม Facebook link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Facebook');

    await page.locator('#facebook-url').fill('https://facebook.com/testpage123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Facebook link โดยเพิ่ม http://
  test('เพิ่ม Facebook link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Facebook');

    await page.locator('#facebook-url').fill('http://facebook.com/testpage123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Facebook link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม Facebook link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Facebook');

    await page.locator('#facebook-url').fill('www.facebook.com/testpage123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข Facebook Link
  test('แก้ไข Facebook Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Facebook');

    await page.locator('#facebook-url').fill('https://facebook.com/testpage123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ Facebook Link
  test('ลบ Facebook Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Facebook');

    await page.locator('#facebook-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== YOUTUBE TESTS ==========
  // เพิ่ม YouTube link โดยเพิ่ม https://
  test('เพิ่ม YouTube link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Youtube');

    await page.locator('#youtube-url').fill('https://youtube.com/channel/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม YouTube link โดยเพิ่ม http://
  test('เพิ่ม YouTube link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Youtube');

    await page.locator('#youtube-url').fill('http://youtube.com/channel/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม YouTube link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม YouTube link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Youtube');

    await page.locator('#youtube-url').fill('www.youtube.com/channel/test123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข YouTube Link
  test('แก้ไข YouTube Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Youtube');

    await page.locator('#youtube-url').fill('https://youtube.com/channel/test123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ YouTube Link
  test('ลบ YouTube Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Youtube');

    await page.locator('#youtube-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  // ========== X (TWITTER) TESTS ==========
  // เพิ่ม X link โดยเพิ่ม https://
  test('เพิ่ม X link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('X');

    await page.locator('#twitter-url').fill('https://x.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม X link โดยเพิ่ม http://
  test('เพิ่ม X link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('X');

    await page.locator('#twitter-url').fill('http://x.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม X link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม X link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('X');

    await page.locator('#twitter-url').fill('www.x.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข X Link
  test('แก้ไข X Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('X');

    await page.locator('#twitter-url').fill('https://x.com/testuser123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ X Link
  test('ลบ X Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('X');

    await page.locator('#twitter-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== INSTAGRAM TESTS ==========
  // เพิ่ม Instagram link โดยเพิ่ม https://
  test('เพิ่ม Instagram link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Instagram');

    await page.locator('#instagram-url').fill('https://instagram.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Instagram link โดยเพิ่ม http://
  test('เพิ่ม Instagram link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Instagram');

    await page.locator('#instagram-url').fill('http://instagram.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Instagram link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม Instagram link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Instagram');

    await page.locator('#instagram-url').fill('www.instagram.com/testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข Instagram Link
  test('แก้ไข Instagram Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Instagram');

    await page.locator('#instagram-url').fill('https://instagram.com/testuser123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ Instagram Link
  test('ลบ Instagram Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Instagram');

    await page.locator('#instagram-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== TIKTOK TESTS ==========
  // เพิ่ม TikTok link โดยเพิ่ม https://
  test('เพิ่ม TikTok link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Tiktok');

    await page.locator('#tiktok-url').fill('https://tiktok.com/@testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม TikTok link โดยเพิ่ม http://
  test('เพิ่ม TikTok link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Tiktok');

    await page.locator('#tiktok-url').fill('http://tiktok.com/@testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม TikTok link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม TikTok link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Tiktok');

    await page.locator('#tiktok-url').fill('www.tiktok.com/@testuser123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข TikTok Link
  test('แก้ไข TikTok Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Tiktok');

    await page.locator('#tiktok-url').fill('https://tiktok.com/@testuser123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ TikTok Link
  test('ลบ TikTok Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Tiktok');

    await page.locator('#tiktok-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== SHOPEE TESTS ==========
  // เพิ่ม Shopee link โดยเพิ่ม https://
  test('เพิ่ม Shopee link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Shopee');

    await page.locator('#shopee-url').fill('https://shopee.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Shopee link โดยเพิ่ม http://
  test('เพิ่ม Shopee link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Shopee');

    await page.locator('#shopee-url').fill('http://shopee.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Shopee link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม Shopee link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Shopee');

    await page.locator('#shopee-url').fill('www.shopee.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข Shopee Link
  test('แก้ไข Shopee Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Shopee');

    await page.locator('#shopee-url').fill('https://shopee.co.th/testshop123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ Shopee Link
  test('ลบ Shopee Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Shopee');

    await page.locator('#shopee-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ========== LAZADA TESTS ==========
  // เพิ่ม Lazada link โดยเพิ่ม https://
  test('เพิ่ม Lazada link โดยเพิ่ม https://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Lazada');

    await page.locator('#lazada-url').fill('https://lazada.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Lazada link โดยเพิ่ม http://
  test('เพิ่ม Lazada link โดยเพิ่ม http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Lazada');

    await page.locator('#lazada-url').fill('http://lazada.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม Lazada link โดยไม่เพิ่ม https:// หรือ http://
  test('เพิ่ม Lazada link โดยไม่เพิ่ม https:// หรือ http://', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Lazada');

    await page.locator('#lazada-url').fill('www.lazada.co.th/testshop123');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Please enter http:// or https://');
  });

  // แก้ไข Lazada Link
  test('แก้ไข Lazada Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Lazada');

    await page.locator('#lazada-url').fill('https://lazada.co.th/testshop123-update');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ Lazada Link
  test('ลบ Lazada Link', async ({ page }) => {
    await ContactSocial(page);
    await expect(page.locator('#social')).toContainText('Lazada');

    await page.locator('#lazada-url').fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  // Information 
  test('กรอกชื่อและอักขระพิเศษ - Successful', async ({ page }) => {
    await ContactInformation(page);

    await expect(page.locator('[id="1"]')).toContainText('Information')


    await expect(page.locator('#info')).toContainText('Name');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('บริษัท ABC จำกัด (มหาชน) & Co., Ltd.');

    await expect(page.locator('#info')).toContainText('Office');
    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('99/99 ถนนพระราม 9 แขวงห้วยขวาง เขตห้วยขวาง กรุงเทพมหานคร 10310');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  test('switch language - Successful', async ({ page }) => {
    await ContactInformation(page);

    await expect(page.locator('[id="1"]')).toContainText('Information')

    await expect(page.locator('#info')).toContainText('Name');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('บริษัท ABC จำกัด (มหาชน) & Co., Ltd.');

    await expect(page.locator('#info')).toContainText('Office');
    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('99/99 ถนนพระราม 9 แขวงห้วยขวาง เขตห้วยขวาง กรุงเทพมหานคร 10310');


    await page.getByRole('combobox', { name: 'English' }).click();
    await page.getByRole('option', { name: 'ภาษาไทย' }).locator('div').first().click();

    await expect(page.locator('#info')).toContainText('Name');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('ABC Company Limited & Co., Ltd.');

    await expect(page.locator('#info')).toContainText('Office');
    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('99/99 Rama 9 Road, Huai Khwang, Bangkok 10310');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  test('กรอกชื่อและรายละเอียดเกิน 255 ตัวอักษร', async ({ page }) => {
    await ContactInformation(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    const longText = 'A'.repeat(300);
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill(longText);

    await page.getByRole('button', { name: ' Save' }).click();

    // ตรวจสอบว่ามีการแสดง error message หรือไม่
    await expect(page.locator('#select2-mwz-select-lang-container')).toContainText('English');
    await expect(page.locator('#name_en-error')).toContainText('This field must not exceed 255 characters');
    await expect(page.locator('#toast-container')).toContainText('Invalid data');

    await page.getByRole('combobox', { name: 'English' }).click();
    await page.getByRole('option', { name: 'ภาษาไทย' }).locator('div').first().click();

    await page.getByRole('button', { name: ' Save' }).click();

    await expect(page.locator('#select2-mwz-select-lang-container')).toContainText('English');
    await expect(page.locator('#name_en-error')).toContainText('This field must not exceed 255 characters');
    await expect(page.locator('#toast-container')).toContainText('Invalid data');
  });

  test('ลบข้อมูล - Successful', async ({ page }) => {
    await ContactInformation(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('');
    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  test('กรอกชื่อ ที่อยู่ ไม่จำกัดตัวอักษร  Successful', async ({ page }) => {
    await ContactInformation(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('ที่อยู่ ไม่จำกัดตัวอักษร');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('ชื่อ');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // // แก้ไขที่อยู่ และอักขระพิเศษ  แก้ไขที่อยู่โดยมีอักขระพิเศษ Successful
  test('แก้ไขที่อยู่ และอักขระพิเศษ  แก้ไขที่อยู่โดยมีอักขระพิเศษ Successful', async ({ page }) => {
    await ContactInformation(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('ที่อยู่ ไม่จำกัดตัวอักษร');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('ชื่อ');
  });

  // // ลบที่อยู่
  test('ลบที่อยู่ Successful', async ({ page }) => {
    await ContactInformation(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    await page.getByRole('textbox', { name: 'Please specify Office' }).fill('');
    await page.getByRole('textbox', { name: 'Please specify Name' }).fill('');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  // กรอกอีเมล email@email -Successful
  test('กรอกอีเมลรูปแบบถูกต้อง - Successful', async ({ page }) => {
    await Contacts(page);

    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await expect(page.locator('#contact')).toContainText('Email');
    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('email@email.com');

    await expect(page.locator('#contact')).toContainText('Phone Number');
    await page.getByRole('textbox', { name: 'Please specify Phone Number' }).fill('0812345678');

    await expect(page.locator('#contact')).toContainText('Google Map');
    await page.getByRole('textbox', { name: 'Please specify Google Map' }).fill('https://www.google.com/maps');

    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // // กรอกตัวอักษรอย่างเดียว - Alert text field valid email address.
  test('กรอกอีเมลเป็นตัวอักษรอย่างเดียว - แสดงแจ้งเตือนรูปแบบอีเมลไม่ถูกต้อง', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await expect(page.locator('#contact')).toContainText('Email');
    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('email.com');
    await page.getByRole('button', { name: ' Save' }).click();

    await expect(page.locator('#email-error')).toContainText('Please enter a valid email address with @ symbol');
    await expect(page.locator('#toast-container')).toContainText('Invalid data');
  });

  // กรอกตัวอักษรเกิน 255 ตัว โดยมีอักษร @ - Fail
  test('อีเมล >255 ตัวอักษร และมี @ - แสดงแจ้งเตือน', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    const longLocal = 'a'.repeat(120);
    const longDomain = 'b'.repeat(140);
    const longEmail = `${longLocal}@${longDomain}.com`; // > 255 chars

    await page.getByRole('textbox', { name: 'Please specify Email' }).fill(longEmail);
    await page.getByRole('button', { name: ' Save' }).click();

    await expect(page.locator('#toast-container')).toContainText('Invalid data');
  });


  // แก้ไขอีเมล - Successful 
  test('แก้ไขอีเมล - Successful', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('change@test.com');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  //ลบ - Successful
  test('ลบอีเมล - Successful', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Information');

    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });


  // เพิ่ม Field number -กรอกตัวเลข  - Successful
  test('เพิ่ม Field number - กรอกตัวเลข - Successful', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await page.getByRole('textbox', { name: 'Please specify Phone Number' }).fill('021234567');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // กรอกเบอร์โทรศัพท์เกิน 30 ตัว. - กรอกตัวเลข  Successful
  test('กรอกเบอร์โทรศัพท์เกิน 30 ตัว - แสดงแจ้งเตือน', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await page.getByRole('textbox', { name: 'Please specify Phone Number' }).fill('9'.repeat(31));
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#tel-error')).toContainText('This field must not exceed 30 characters');
    await expect(page.locator('#toast-container')).toContainText('Invalid data');
  });

  // กรอกอักษรอย่างเดียว - Proper Alert message is shown
  test('อีเมลเป็นอักษรอย่างเดียวซ้ำ - แสดงแจ้งเตือน', async ({ page }) => {
    await Contacts(page);
    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('aaaaa');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Invalid data');
  });

  // ลบข้อมูล - Successful
  test('ลบข้อมูลติดต่อ - Successful', async ({ page }) => {
    await Contacts(page);
    await expect(page.locator('[id="1"]')).toContainText('Contact');

    await expect(page.locator('#contact')).toContainText('Email');
    await page.getByRole('textbox', { name: 'Please specify Email' }).fill('');

    await expect(page.locator('#contact')).toContainText('Phone Number');
    await page.getByRole('textbox', { name: 'Please specify Phone Number' }).fill('');

    await expect(page.locator('#contact')).toContainText('Google Map');
    await page.getByRole('textbox', { name: 'Please specify Google Map' }).fill('');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // Google Map กรอก Link Google map - Successful
  test('Google Map - กรอกลิงก์ Google Map - Successful', async ({ page }) => {
    await Contacts(page);
    await page.getByRole('textbox', { name: 'Please specify Google map' }).fill('https://maps.google.com/?q=13.7563,100.5018');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // เพิ่ม link ที่ไม่ใช่ google map -Successful
  test('Google Map - ลิงก์ไม่ใช่ Google Map - Successful', async ({ page }) => {
    await Contacts(page);
    await page.getByRole('textbox', { name: 'Please specify Google map' }).fill('https://example.com/page');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // แก้ไข Link Google map - Successful
  test('Google Map - แก้ไขลิงก์ - Successful', async ({ page }) => {
    await Contacts(page);
    await page.getByRole('textbox', { name: 'Please specify Google map' }).fill('https://maps.google.com/?q=13.7000,100.5000');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

  // ลบ - Successful
  test('Google Map - ลบลิงก์ - Successful', async ({ page }) => {
    await Contacts(page);
    await page.getByRole('textbox', { name: 'Please specify Google map' }).fill('');
    await page.getByRole('button', { name: ' Save' }).click();
    await expect(page.locator('#toast-container')).toContainText('Successfully saved changes');
  });

});