<!DOCTYPE html>
<html lang="th">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Application for Transportation Fee</title>
    <link rel="stylesheet" href="assets/pdf/transportation.css">
    <style>
        body {
            font-family: 'NotoSansThai', sans-serif;
            font-size: 14pt;
        }
        
        html,
        body,
        * {
            font-family: 'NotoSansThai', sans-serif !important;
        }

        .received-line {
            border-bottom: 1px solid #000;
            height: 1.2em;
            display: inline-block;
            vertical-align: baseline;
        }

        .page-break {
            page-break-after: always;
        }

        .page-break:last-child {
            page-break-after: auto;
        }

        .page-wrapper {
            page-break-inside: avoid;
        }
    </style>
</head>

<body>
    <?php
        $rowsPerPage = 7;
        $chunks = array_chunk($rows, $rowsPerPage);
        $totalPages = count($chunks);
        $totalAmount = collect($rows)->sum('amount');
    ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pageIndex => $pageRows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="page page-wrapper <?php echo e($pageIndex < $totalPages - 1 ? 'page-break' : ''); ?>">
            
            <div class="header">
                <table class="">
                    <thead>
                        <tr>
                            <th width="5%">
                                <div class="logo-wrap">
                                    <img src="<?php echo e(public_path('assets/frontend/images/logo.png')); ?>" alt="NA Logo">
                                </div>
                            </th>
                            <th width="30%" style="text-align: left; font-size: 8pt;">
                                <div class="">
                                    <div class="name">NA Caltechnologies Co.,Ltd.</div>
                                    <div class="addr">75/107 Moo 11, Klongnueng, Klongluang, Pathumthani 12120, Thailand
                                    </div>
                                    <div class="contact">Tel. +662-529-2460-5 Fax. +662-529-2133, +662-529-2466</div>
                                    <div class="tax">Tax ID: 0135559011494</div>
                                </div>
                            </th>
                            <th width="18%" style="text-align: right; font-size: 8pt;">
                                <div>HR-FM-402</div>
                            </th>
                        </tr>
                    </thead>
                </table>
                <h1>APPLICATION FOR TRANSPORTATION FEE</h1>
            </div>

            <div class="header">
                <table class="">
                    <thead>
                        <tr>
                            <th width="5%">
                                &nbsp;
                            </th>
                            <th width="30%" style="text-align: left;">
                                &nbsp;
                            </th>
                            <th width="18%" style="text-align: right;">
                                <table class="detail-table">
                                    <thead>
                                        <tr>
                                            <th width="10%">DIVISION</th>
                                            <th width="8%">DEPARTMENT</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td  style="text-align: center;"><?php echo e($employee['department']); ?></td>
                                            <td  style="text-align: center;"><?php echo e($employee['date_fo_print']); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pageIndex === 0): ?>
                <table class="detail-table">
                    <thead>
                        <tr>
                            <th style="text-align: center;" width="8%">EMPLOYEE NO.</th>
                            <th style="text-align: center;" width="10%">NAME</th>
                            <th style="text-align: center;" width="18%">DATE OF APPLICATION</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="text-align: center;"><?php echo e($employee['code']); ?></td>
                            <td style="text-align: center;"><?php echo e($employee['name']); ?></td>
                            <td style="text-align: center;"><?php echo e(date('d/m/Y')); ?></td>
                        </tr>
                    </tbody>
                </table>

                <table class="detail-table">
                    <thead>
                        <tr>
                            <th width="25%">Department Manager</th>
                            <th width="25%">Division Manager / Head of BU</th>
                            <th width="25%">HR</th>
                            <th width="25%">GA & ACC Manager</th>
                        </tr>
                      
                    </thead>
                    <tbody>
                        <tr>
                            <td style="height: 40px;"><?php echo e($employee['approve']['manager']['name'] ?? ''); ?></td>
                            <td style="height: 40px;"><?php echo e($employee['approve']['bu']['name'] ?? ''); ?></td>
                            <td style="height: 40px;"></td>
                            <td style="height: 40px;"></td>
                        </tr>
                        <tr>
                            <td>DATE : <?php echo e($employee['approve']['manager']['date'] ?? ''); ?></td>
                            <td>DATE : <?php echo e($employee['approve']['bu']['date'] ?? ''); ?></td>
                            <td>DATE</td>
                            <td>DATE</td>
                        </tr>
                    </tbody>
                </table>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <table class="detail-table" style="text-align: center !important;">
                <thead>
                    <tr>
                        <th width="10%"><small>DATE / MONTH</small></th>
                        <th width="8%"><small>TIME</small> <br> <small>(HH:MM)</small></th>
                        <th width="15%"><small>FROM <span class="th-sep">COMPANY</span></small></th>
                        <th width="15%"><small>TO <span class="th-sep">COMPANY</span></small></th>
                        <th width="15%"><small>PURPOSE</small></th>
                        <th width="15%"><small>DISTANCE (KM)</small> <br> <small>(KM)</small></th>
                        <th width="15%"><small>RATE (ราคาน้ำมัน)</small> <br> <small>(THB)</small></th>
                        <th width="10%"><small>AMOUNT</small> <br> <small>(THB)</small></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pageRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item['date']); ?></td>
                            <td><?php echo e($item['time']); ?></td>
                            <td><?php echo e($item['from_company']); ?></td>
                            <td><?php echo e($item['to_company']); ?></td>
                            <td><?php echo e($item['purpose']); ?></td>
                            <td class="text-right"><?php echo e(number_format($item['distance_km'], 2)); ?></td>
                            <td class="text-right"><?php echo e(number_format($item['oil_cost'], 2)); ?></td>
                            <td class="text-right"><?php echo e(number_format($item['amount'], 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = count($pageRows); $i < $rowsPerPage; $i++): ?>
                        <tr>
                            <td>&nbsp;</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pageIndex === $totalPages - 1): ?>
                    <tfoot>
                        <tr>
                            <td colspan="7" class="text-right bold">TOTAL AMOUNT</td>
                            <td class="text-right bold"><?php echo e(number_format($totalAmount, 2)); ?></td>
                        </tr>
                    </tfoot>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </table>

            
            <div class="footer">
                <table>
                    <thead>
                        <tr>
                            <th width="70%" style="font-size: 8pt;">
                                <div style="text-align: left;">REMARKS :</div>
                                <div style="font-weight: normal; text-align: left;">
                                    (1) THIS FORM SHALL BE USED FOR REIMBURSEMENT OF TAXI FARE, BUS FARE, GAS CHARGE OF THE
                                    SUPERVISORS, STAFFS CAR FOR BUSINESS USE.
                                </div>
                                <div style="font-weight: normal; text-align: left;">
                                    (2) THE ACCOUNTING & FINANCE DEPT. WILL REIMBURSE AFTER APPROVAL
                                </div>
                                <div style="font-weight: normal; text-align: left;">
                                    (3) THIS APPLICATION FORM WILL BE SUBMITTED ON THE DAY OF 15 AND END OF THE MONTH.
                                </div>
                            </th>
                            <th width="30%">
                                <div class="received" style="text-align: left;">
                                    <div class="box">
                                        <div class="received-title">RECEIVED BY:</div>
                                        <table>
                                            <tr>
                                                <td>NAME</td>
                                                <td class="received-line" style="width:120px;">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td>SIGNATURE</td>
                                                <td class="received-line" style="width:120px;">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td>DATE</td>
                                                <td class="received-line" style="width:120px;">&nbsp;</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="rev">Rev.02 (09-10-25)</div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</body>

</html>
<?php /**PATH /newdata/uatnewndco/public_html/nacal-hr.mwz/Modules/Frontend/resources/views/pdf/transportation.blade.php ENDPATH**/ ?>