<!DOCTYPE html>
<?php $lang = app()->getLocale() ?? config('app.fallback_locale'); ?>
<html lang="{{ $lang }}">

<head>
    <!-- meta -->
    @include('master.app-meta')
    <!-- meta -->

    <!-- styles -->
    @include('table.styles')
    <!-- styles -->
</head>

<body class="loading" data-layout-color="light" data-layout-mode="default" data-layout-size="fluid" data-topbar-color="light"
    data-leftbar-position="fixed" data-leftbar-color="light" data-leftbar-size='default' data-sidebar-user='true'>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- navbar -->
        <?php $navbar = $navbar ?? null; ?>
        <x-main.header :navbar=$navbar />

        <!-- sidebar-menu -->
        <x-side.sidebar />

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <!-- content -->
                    @yield('content')
                </div>
            </div>

            <!-- footer -->
            <x-main.footer />

            <!-- scroll-top -->
            <x-main.scroll-top />

        </div>
    </div>
    <!-- END wrapper -->
    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>
    <!-- scripts -->
    @include('table.scripts')
    <!-- scripts -->
</body>

</html>
