<!DOCTYPE html>
<?php $lang = app()->getLocale() ?? config('app.fallback_locale'); ?>
<html lang="{{ $lang }}">

<head>
    <?php
    $title = 'Log In | Z.com';
    $author = 'Log In | Z.com';
    $keywords = $web->{"meta_keywords_{$lang}"} ?? 'Z.com';
    $desc = 'Z.com | A fully featured admin theme which can be used to build CRM, CMS, etc.';
    $favicon = asset('assets/images/favicon.ico');
    ?>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <meta name="description" content="{{ $desc }}" />
    <meta name="keywords" content="{{ $keywords }}">
    <meta name="author" content="{{ $author }}" />
    <link rel="shortcut icon" href="{{ $favicon }}">
    <title>{{ $title }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    {{-- styles --}}
    @include('error.assets.styles')
    {{-- styles --}}
</head>

<body class="loading authentication-bg authentication-bg-pattern">

    <div class="account-pages mt-5 mb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-4">
                    <div class="card bg-pattern">

                        <div class="card-body p-4">

                            <div class="text-center w-75 m-auto">
                                <div class="auth-logo">
                                    <a href="{{ route('admin.homepage') }}" class="logo logo-dark text-center">
                                        <span class="logo-lg">
                                            <img class="w-100" src="{{ asset('assets/images/logo-dark.png') }}">
                                        </span>
                                    </a>

                                    <a href="{{ route('admin.homepage') }}" class="logo logo-light text-center">
                                        <span class="logo-lg">
                                            <img class="w-100" src="{{ asset('assets/images/logo-light.png') }}">
                                        </span>
                                    </a>
                                </div>
                            </div>

                            <div class="text-center mt-4">
                                <h3>See you again !</h3>

                                <p class="text-muted"> {{ __('admin.error.permitted.desc') }} </p>
                            </div>

                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                    <div class="row mt-3">
                        <div class="col-12 text-center">
                            <p class="text-muted">{{ __('admin.error.permitted.footer') }}
                                <a href="{{ route('admin.logout') }}" class="text-dark ms-1">
                                    <b>{{ __('action.signin') }}</b></a>
                            </p>
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->
    {{-- scripts --}}
    @include('error.assets.scripts')
    {{-- scripts --}}
</body>

</html>
