<div class="container {{ $class }}" id="level-{{ $level }}-{{ $pid }}">
    <div class="row">
        <div class="col-12 col-md-4 {{ $class_header }}">
            <input class="form-check-input" id="{{ $pid }}" type="checkbox" value="all" onclick="set_all(this, 'level-{{ $level }}-{{ $pid }}')" @if (!empty($super)) checked disabled @endif>
            <label class="form-check-label" for="{{ $pid }}">{!! $header !!}</label>
        </div>
        @php
            $arr = array_keys($permission);
        @endphp
        @foreach (['export', 'add', 'edit', 'view'] as $cb)
            <div class="col col-md-2">
                @if (in_array($cb, $arr))
                    @php
                        $permission_id = $permission[$cb][0];
                    @endphp
                    <div class="form-check">
                        <input class="form-check-input" id="{{ $pid }}_{{ $permission_id }}" name="permissions[]" data-pid="{{ $pid }}" data-status="{{ $cb }}" type="checkbox" value="{{ $permission_id }}" onclick="check_status(this, 'level-{{ $level }}-{{ $pid }}');" @if (!empty($super)) checked disabled @endif>
                        <label class="form-check-label" for="{{ $pid }}_{{ $permission_id }}">{{ __("action.{$cb}") }}</label>
                        @foreach ($permission[$cb] as $key => $val)
                            @if ($key == 0)
                                @continue
                            @endif
                            <input class="d-none" name="permissions[]" data-children="{{ $pid }}_{{ $permission_id }}" data-pid="{{ $pid }}" data-status="{{ $cb }}" type="checkbox" value="{{ $val }}">
                        @endforeach
                    </div>
                @endif
            </div>
        @endforeach
        
        {{-- OilPrice ABC Checkboxes --}}
        @if (str_contains($header, 'Scheme'))
            <div class="col-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">การจัดการค่า A, B, C</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" id="{{ $pid }}_value_a" name="oilprice_abc[]" type="checkbox" value="value_a" data-pid="{{ $pid }}" onclick="check_status(this, 'level-{{ $level }}-{{ $pid }}'); check_oilprice_abc(this, 'level-{{ $level }}-{{ $pid }}');"
                                        @if (!empty($super)) checked disabled @endif
                                        @if (empty($super) && !empty($oilpriceAbcChecked ?? [] ) && in_array('value_a', $oilpriceAbcChecked)) checked @endif>
                                    <label class="form-check-label" for="{{ $pid }}_value_a">
                                        A
                                    </label>
                                    <small class="text-muted d-block">อัตราสิ้นเปลือง</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" id="{{ $pid }}_value_b" name="oilprice_abc[]" type="checkbox" value="value_b" data-pid="{{ $pid }}" onclick="check_status(this, 'level-{{ $level }}-{{ $pid }}'); check_oilprice_abc(this, 'level-{{ $level }}-{{ $pid }}');"
                                        @if (!empty($super)) checked disabled @endif
                                        @if (empty($super) && !empty($oilpriceAbcChecked ?? [] ) && in_array('value_b', $oilpriceAbcChecked)) checked @endif>
                                    <label class="form-check-label" for="{{ $pid }}_value_b">
                                        B
                                    </label>
                                    <small class="text-muted d-block">ค่าเสื่อมรถตามจริง</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" id="{{ $pid }}_value_c" name="oilprice_abc[]" type="checkbox" value="value_c" data-pid="{{ $pid }}" onclick="check_status(this, 'level-{{ $level }}-{{ $pid }}'); check_oilprice_abc(this, 'level-{{ $level }}-{{ $pid }}');"
                                        @if (!empty($super)) checked disabled @endif
                                        @if (empty($super) && !empty($oilpriceAbcChecked ?? [] ) && in_array('value_c', $oilpriceAbcChecked)) checked @endif>
                                    <label class="form-check-label" for="{{ $pid }}_value_c">
                                        C
                                    </label>
                                    <small class="text-muted d-block">แรงกระตุ้นให้เกิดการใช้รถ</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
