<label class="form-label"> {{ $label ?? __('admin.upload.title') }}</label>
<label for="upload_image{{ $id }}" class="label-upload i">
    <div class="image-upload mwz-image-upload upload_image{{ $id }}" data-id="{{ $id }}"
        data-size="{{ $size ?? '' }}">
        <button type="button" id="btn_delete{{ $id }}"
            class="btn btn-danger waves-effect waves-light btn-upload"
            data-cancel-txt="{{ __('admin.upload.cancel_txt') }}"
            data-confirm-del-txt="{{ __('admin.upload.confirm_del_txt') }}"
            data-confirm-txt="{{ __('admin.upload.confirm_txt') }}"
            data-upload-click-to-upload-txt="{{ __('admin.upload.txt') }}"
            {{ empty($image) ? 'style=display:none;' : '' }}>{{ __('admin.upload.del_txt') }}
        </button>
        <div class="dz-message upload_show_img_container">
            @if (!empty($image))
                <div id="upload_show_img_{{ $id }}">
                    <div id="upload_show_upload_{{ $id }}" class="d-upload-image">
                        <p>
                            @switch($type)
                                @case('file')
                                    <i class="mdi mdi-file" style="font-size: 64px"></i>
                                @break

                                @case('video')
                                    <iframe style="max-height: 150px" class="img-responsive"
                                        src="{{ $image }}"></iframe>
                                @break

                                @default
                                    <img style="max-height: 150px" class="img-responsive" src="{{ $image }}"
                                        alt="Thumb-1">
                            @endswitch
                        </p>
                    </div>
                </div>
            @else
                <div class="d-upload-image">
                    <i class="mdi mdi-cloud-upload-outline"></i>
                    <p><b>{{ __('admin.upload.txt') }}</b></p>
                </div>
            @endif
        </div>
        <div class="input-upload">
            <input name="{{ $name }}" id="upload_image{{ $id }}" type="file"
                accept="{{ $accept }}" />
            <input name="{{ $name }}_del" id="upload_image{{ $id }}_del" type="hidden"
                value="0" />
            <input name="{{ $name }}_old" id="upload_image{{ $id }}_old" type="hidden"
                value="{{ $image ?? '' }}" />
        </div>
    </div>
</label>
<span class="upload-recommend">{{ __('admin.upload.recommend') }}&nbsp;{{ $recommend ?? '' }}</span>
