<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'กรุณายอมรับ :attribute',
    'accepted_if' => 'กรุณายอมรับ :attribute เมื่อ :other เป็น :value',
    'active_url' => ':attribute ไม่ใช่ URL ที่ถูกต้อง',
    'after' => ':attribute ต้องเป็นวันที่หลังจาก :date',
    'after_or_equal' => ':attribute ต้องเป็นวันที่หลังจากหรือเท่ากับ :date',
    'alpha' => ':attribute ต้องประกอบด้วยตัวอักษรเท่านั้น',
    'alpha_dash' => ':attribute ต้องประกอบด้วยตัวอักษร ตัวเลข ขีดกลาง และขีดล่างเท่านั้น',
    'alpha_num' => ':attribute ต้องประกอบด้วยตัวอักษรและตัวเลขเท่านั้น',
    'array' => ':attribute ต้องเป็นอาร์เรย์',
    'ascii' => ':attribute ต้องประกอบด้วยตัวอักษรและสัญลักษณ์แบบ single-byte เท่านั้น',
    'before' => ':attribute ต้องเป็นวันที่ก่อน :date',
    'before_or_equal' => ':attribute ต้องเป็นวันที่ก่อนหรือเท่ากับ :date',
    'between' => [
        'array' => ':attribute ต้องมีจำนวนระหว่าง :min ถึง :max รายการ',
        'file' => ':attribute ต้องมีขนาดระหว่าง :min ถึง :max กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าอยู่ระหว่าง :min ถึง :max',
        'string' => ':attribute ต้องมีความยาวระหว่าง :min ถึง :max ตัวอักษร',
    ],
    'boolean' => ':attribute ต้องเป็น true หรือ false เท่านั้น',
    'can' => ':attribute มีค่าที่ไม่ได้รับอนุญาต',
    'confirmed' => 'การยืนยัน :attribute ไม่ตรงกัน',
    'current_password' => 'รหัสผ่านไม่ถูกต้อง',
    'date' => ':attribute ไม่ใช่วันที่ที่ถูกต้อง',
    'date_equals' => ':attribute ต้องเป็นวันที่เท่ากับ :date',
    'date_format' => ':attribute ไม่ตรงกับรูปแบบ :format',
    'decimal' => ':attribute ต้องมีทศนิยม :decimal ตำแหน่ง',
    'declined' => ':attribute ต้องถูกปฏิเสธ',
    'declined_if' => ':attribute ต้องถูกปฏิเสธเมื่อ :other เป็น :value',
    'different' => ':attribute และ :other ต้องไม่เหมือนกัน',
    'digits' => ':attribute ต้องเป็นตัวเลข :digits หลัก',
    'digits_between' => ':attribute ต้องเป็นตัวเลขระหว่าง :min ถึง :max หลัก',
    'dimensions' => ':attribute มีขนาดภาพไม่ถูกต้อง',
    'distinct' => ':attribute มีค่าซ้ำกัน',
    'doesnt_end_with' => ':attribute ต้องไม่ลงท้ายด้วย: :values',
    'doesnt_start_with' => ':attribute ต้องไม่ขึ้นต้นด้วย: :values',
    'email' => 'รูปแบบ :attribute ไม่ถูกต้อง',
    'ends_with' => ':attribute ต้องลงท้ายด้วย: :values',
    'enum' => ':attribute ที่เลือกไม่ถูกต้อง',
    'exists' => ':attribute ที่เลือกไม่มีอยู่',
    'extensions' => ':attribute ต้องมีนามสกุลไฟล์: :values',
    'file' => ':attribute ต้องเป็นไฟล์',
    'filled' => ':attribute ต้องมีค่า',
    'gt' => [
        'array' => ':attribute ต้องมีมากกว่า :value รายการ',
        'file' => ':attribute ต้องมีขนาดมากกว่า :value กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่ามากกว่า :value',
        'string' => ':attribute ต้องมีความยาวมากกว่า :value ตัวอักษร',
    ],
    'gte' => [
        'array' => ':attribute ต้องมีอย่างน้อย :value รายการ',
        'file' => ':attribute ต้องมีขนาดอย่างน้อย :value กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าอย่างน้อย :value',
        'string' => ':attribute ต้องมีความยาวอย่างน้อย :value ตัวอักษร',
    ],
    'hex_color' => ':attribute ต้องเป็นสีแบบ hexadecimal ที่ถูกต้อง',
    'image' => ':attribute ต้องเป็นรูปภาพ',
    'in' => ':attribute ที่เลือกไม่ถูกต้อง',
    'in_array' => ':attribute ไม่มีอยู่ใน :other',
    'integer' => ':attribute ต้องเป็นจำนวนเต็ม',
    'ip' => ':attribute ต้องเป็น IP address ที่ถูกต้อง',
    'ipv4' => ':attribute ต้องเป็น IPv4 address ที่ถูกต้อง',
    'ipv6' => ':attribute ต้องเป็น IPv6 address ที่ถูกต้อง',
    'json' => ':attribute ต้องเป็น JSON string ที่ถูกต้อง',
    'lowercase' => ':attribute ต้องเป็นตัวพิมพ์เล็ก',
    'lt' => [
        'array' => ':attribute ต้องมีน้อยกว่า :value รายการ',
        'file' => ':attribute ต้องมีขนาดน้อยกว่า :value กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าน้อยกว่า :value',
        'string' => ':attribute ต้องมีความยาวน้อยกว่า :value ตัวอักษร',
    ],
    'lte' => [
        'array' => ':attribute ต้องมีไม่เกิน :value รายการ',
        'file' => ':attribute ต้องมีขนาดไม่เกิน :value กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าไม่เกิน :value',
        'string' => ':attribute ต้องมีความยาวไม่เกิน :value ตัวอักษร',
    ],
    'mac_address' => ':attribute ต้องเป็น MAC address ที่ถูกต้อง',
    'max' => [
        'array' => ':attribute ต้องมีไม่เกิน :max รายการ',
        'file' => ':attribute ต้องมีขนาดไม่เกิน :max กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าไม่เกิน :max',
        'string' => ':attribute ต้องมีความยาวไม่เกิน :max ตัวอักษร',
    ],
    'max_digits' => ':attribute ต้องมีไม่เกิน :max หลัก',
    'mimes' => ':attribute ต้องเป็นไฟล์ประเภท: :values',
    'mimetypes' => ':attribute ต้องเป็นไฟล์ประเภท: :values',
    'min' => [
        'array' => ':attribute ต้องมีอย่างน้อย :min รายการ',
        'file' => ':attribute ต้องมีขนาดอย่างน้อย :min กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่าอย่างน้อย :min',
        'string' => ':attribute ต้องมีความยาวอย่างน้อย :min ตัวอักษร',
    ],
    'min_digits' => ':attribute ต้องมีอย่างน้อย :min หลัก',
    'missing' => ':attribute หายไป',
    'missing_if' => ':attribute หายไปเมื่อ :other เป็น :value',
    'missing_unless' => ':attribute หายไปเว้นแต่ :other เป็น :value',
    'missing_with' => ':attribute หายไปเมื่อ :values มีอยู่',
    'missing_with_all' => ':attribute หายไปเมื่อ :values มีอยู่ทั้งหมด',
    'multiple_of' => ':attribute ต้องเป็นผลคูณของ :value',
    'not_in' => ':attribute ที่เลือกไม่ถูกต้อง',
    'not_regex' => 'รูปแบบ :attribute ไม่ถูกต้อง',
    'numeric' => ':attribute ต้องเป็นตัวเลข',
    'password' => [
        'letters' => ':attribute ต้องมีตัวอักษรอย่างน้อย 1 ตัว',
        'mixed' => ':attribute ต้องมีตัวพิมพ์ใหญ่และตัวพิมพ์เล็กอย่างน้อยอย่างละ 1 ตัว',
        'numbers' => ':attribute ต้องมีตัวเลขอย่างน้อย 1 ตัว',
        'symbols' => ':attribute ต้องมีสัญลักษณ์อย่างน้อย 1 ตัว',
        'uncompromised' => ':attribute ที่ให้มาเคยรั่วไหลในข้อมูล กรุณาเลือก :attribute อื่น',
    ],
    'present' => ':attribute ต้องมีอยู่',
    'present_if' => ':attribute ต้องมีอยู่เมื่อ :other เป็น :value',
    'present_unless' => ':attribute ต้องมีอยู่เว้นแต่ :other เป็น :value',
    'present_with' => ':attribute ต้องมีอยู่เมื่อ :values มีอยู่',
    'present_with_all' => ':attribute ต้องมีอยู่เมื่อ :values มีอยู่ทั้งหมด',
    'prohibited' => ':attribute ถูกห้าม',
    'prohibited_if' => ':attribute ถูกห้ามเมื่อ :other เป็น :value',
    'prohibited_unless' => ':attribute ถูกห้ามเว้นแต่ :other อยู่ใน :values',
    'prohibits' => ':attribute ห้าม :other มีอยู่',
    'regex' => 'รูปแบบ :attribute ไม่ถูกต้อง',
    'required' => 'กรุณากรอก :attribute',
    'required_array_keys' => ':attribute ต้องมีรายการสำหรับ: :values',
    'required_if' => ':attribute จำเป็นเมื่อ :other เป็น :value',
    'required_if_accepted' => ':attribute จำเป็นเมื่อ :other ถูกยอมรับ',
    'required_unless' => ':attribute จำเป็นเว้นแต่ :other อยู่ใน :values',
    'required_with' => ':attribute จำเป็นเมื่อ :values มีอยู่',
    'required_with_all' => ':attribute จำเป็นเมื่อ :values มีอยู่ทั้งหมด',
    'required_without' => ':attribute จำเป็นเมื่อ :values ไม่มีอยู่',
    'required_without_all' => ':attribute จำเป็นเมื่อ :values ไม่มีอยู่เลย',
    'same' => ':attribute และ :other ต้องเหมือนกัน',
    'size' => [
        'array' => ':attribute ต้องมี :size รายการ',
        'file' => ':attribute ต้องมีขนาด :size กิโลไบต์',
        'numeric' => ':attribute ต้องมีค่า :size',
        'string' => ':attribute ต้องมีความยาว :size ตัวอักษร',
    ],
    'starts_with' => ':attribute ต้องขึ้นต้นด้วย: :values',
    'string' => ':attribute ต้องเป็นข้อความ',
    'timezone' => ':attribute ต้องเป็นเขตเวลาที่ถูกต้อง',
    'unique' => ':attribute นี้มีอยู่แล้ว',
    'uploaded' => 'การอัปโหลด :attribute ล้มเหลว',
    'uppercase' => ':attribute ต้องเป็นตัวพิมพ์ใหญ่',
    'url' => 'รูปแบบ :attribute ไม่ถูกต้อง',
    'ulid' => ':attribute ต้องเป็น ULID ที่ถูกต้อง',
    'uuid' => ':attribute ต้องเป็น UUID ที่ถูกต้อง',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "rule.attribute" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'ข้อความที่กำหนดเอง',
        ],
        'video' => [
            'mimetypes' => 'กรุณาอัปโหลดไฟล์วิดีโอที่ถูกต้อง รูปแบบที่รองรับ: MP4, AVI, MPEG',
        ],
        'image' => [
            'mimetypes' => 'กรุณาอัปโหลดไฟล์รูปภาพที่ถูกต้อง รูปแบบที่รองรับ: JPG, PNG, GIF, WebP',
        ],
        'document' => [
            'mimetypes' => 'กรุณาอัปโหลดไฟล์เอกสารที่ถูกต้อง รูปแบบที่รองรับ: PDF, DOC, DOCX',
        ],
        'youtube' => [
            'required' => 'กรุณาระบุ Youtube (Embed)',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'video' => 'ไฟล์วิดีโอ',
        'image' => 'ไฟล์รูปภาพ',
        'document' => 'ไฟล์เอกสาร',
        'file' => 'ไฟล์',
        'email' => 'อีเมล',
        'password' => 'รหัสผ่าน',
        'name' => 'ชื่อ',
        'title' => 'หัวข้อ',
        'description' => 'คำอธิบาย',
        'content' => 'เนื้อหา',
        'link' => 'ลิงก์',
        'url' => 'URL',
        'phone' => 'เบอร์โทรศัพท์',
        'address' => 'ที่อยู่',
        'city' => 'เมือง',
        'country' => 'ประเทศ',
        'postal_code' => 'รหัสไปรษณีย์',
        'birth_date' => 'วันเกิด',
        'start_date' => 'วันที่เริ่มต้น',
        'end_date' => 'วันที่สิ้นสุด',
        'price' => 'ราคา',
        'amount' => 'จำนวนเงิน',
        'quantity' => 'จำนวน',
        'status' => 'สถานะ',
        'type' => 'ประเภท',
        'category' => 'หมวดหมู่',
        'tags' => 'แท็ก',
        'notes' => 'หมายเหตุ',
        'comments' => 'ความคิดเห็น',
        'rating' => 'คะแนน',
        'score' => 'คะแนน',
        'level' => 'ระดับ',
        'role' => 'บทบาท',
        'permission' => 'สิทธิ์',
        'username' => 'ชื่อผู้ใช้',
        'first_name' => 'ชื่อ',
        'last_name' => 'นามสกุล',
        'middle_name' => 'ชื่อกลาง',
        'company' => 'บริษัท',
        'website' => 'เว็บไซต์',
        'social_media' => 'โซเชียลมีเดีย',
        'bio' => 'ประวัติ',
        'avatar' => 'รูปโปรไฟล์',
        'cover' => 'รูปปก',
        'banner' => 'รูปแบนเนอร์',
        'logo' => 'โลโก้',
        'icon' => 'ไอคอน',
        'thumbnail' => 'รูปย่อ',
        'gallery' => 'แกลเลอรี่',
        'album' => 'อัลบั้ม',
        'playlist' => 'เพลย์ลิสต์',
        'channel' => 'ช่อง',
        'subscription' => 'การสมัครสมาชิก',
        'membership' => 'การเป็นสมาชิก',
        'plan' => 'แผน',
        'package' => 'แพ็กเกจ',
        'service' => 'บริการ',
        'product' => 'ผลิตภัณฑ์',
        'item' => 'รายการ',
        'order' => 'คำสั่งซื้อ',
        'invoice' => 'ใบแจ้งหนี้',
        'payment' => 'การชำระเงิน',
        'transaction' => 'ธุรกรรม',
        'refund' => 'การคืนเงิน',
        'discount' => 'ส่วนลด',
        'coupon' => 'คูปอง',
        'promo_code' => 'รหัสโปรโมชั่น',
        'shipping' => 'การจัดส่ง',
        'delivery' => 'การจัดส่ง',
        'tracking' => 'การติดตาม',
        'return' => 'การคืนสินค้า',
        'exchange' => 'การแลกเปลี่ยน',
        'warranty' => 'การรับประกัน',
        'support' => 'การสนับสนุน',
        'help' => 'ความช่วยเหลือ',
        'faq' => 'คำถามที่พบบ่อย',
        'contact' => 'การติดต่อ',
        'message' => 'ข้อความ',
        'subject' => 'หัวข้อ',
        'body' => 'เนื้อหาข้อความ',
        'attachment' => 'ไฟล์แนบ',
        'file_upload' => 'การอัปโหลดไฟล์',
        'video_upload' => 'การอัปโหลดวิดีโอ',
        'image_upload' => 'การอัปโหลดรูปภาพ',
        'audio_upload' => 'การอัปโหลดเสียง',
        'document_upload' => 'การอัปโหลดเอกสาร',
    ],
];