<?php

return array(

	/*
    |--------------------------------------------------------------------------
    | Upload dir
    |--------------------------------------------------------------------------
    |
    | The dir where to store the images (relative from public)
    |
    */
	'dir' => ['storage'],

	/*
    |--------------------------------------------------------------------------
    | Filesystem disks (Flysytem)
    |--------------------------------------------------------------------------
    |
    | Define an array of Filesystem disks, which use Flysystem.
    | You can set extra options, example:
    |
    | 'my-disk' => [
    |        'URL' => url('to/disk'),
    |        'alias' => 'Local storage',
    |    ]
    */
	'disks' => [],

	/*
    |--------------------------------------------------------------------------
    | Routes group config
    |--------------------------------------------------------------------------
    |
    | The default group settings for the elFinder routes.
    |
    */

	'route' => [
		'prefix' => '/admin/elfinder',
		'middleware' => array('web', 'auth:admin'), //Set to null to disable middleware filter
	],

	/*
    |--------------------------------------------------------------------------
    | Access filter
    |--------------------------------------------------------------------------
    |
    | Filter callback to check the files
    |
    */

	'access' => 'Barryvdh\Elfinder\Elfinder::checkAccess',

	/*
    |--------------------------------------------------------------------------
    | Roots
    |--------------------------------------------------------------------------
    |
    | By default, the roots file is LocalFileSystem, with the above public dir.
    | If you want custom options, you can set your own roots below.
    |
    */

	'roots' => array(
		array(
			'driver' => 'LocalFileSystem',
			'path' =>  storage_path('app/public'),
			'URL' => '/storage',
			'accessControl' => 'access',             // disable and hide dot starting files (OPTIONAL)
			'alias'         => 'Upload',
			'uploadMaxSize' => '1024M',
			'uploadOrder'   => array('deny', 'allow'),
			'uploadDeny'    => array('all'),
			'uploadAllow'   => array(
				'application/msword',
				'application/pdf',
				'application/vnd.ms-powerpoint',
				'application/vnd.openxmlformats-officedocument.presentationml.presentation',
				'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
				'application/xhtml+xml',
				'application/xml',
				'image',
				'image/svg+xml',
				'text/csv',
				'video/mp4',
				'video/quicktime',
				'video/webm',
				'video/avi',
				'video/mpeg',
				'video/mp4; codecs=hvc1',
			),
		)
	),

	/*
    |--------------------------------------------------------------------------
    | Options
    |--------------------------------------------------------------------------
    |
    | These options are merged, together with 'roots' and passed to the Connector.
    | See https://github.com/Studio-42/elFinder/wiki/Connector-configuration-options-2.1
    |
    */

	'options' => array(),

	/*
    |--------------------------------------------------------------------------
    | Root Options
    |--------------------------------------------------------------------------
    |
    | These options are merged, together with every root by default.
    | See https://github.com/Studio-42/elFinder/wiki/Connector-configuration-options-2.1#root-options
    |
    */
	'root_options' => array(),

);
