<?php

namespace App\View\Components\Upload;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Image extends Component
{
	public $accept;
	public function __construct(
		public $id = 1,
		public $name = 'image',
		public $image = null,
		public $size = 1024,
		public $label = 'image',
		public $type = 'image',
		public $recommend = null,
		public $hiddenBtnDel = false,
	) {
		$this->size = $this->size ? $this->size : str_replace('M', '', ini_get('upload_max_filesize'));
		switch ($this->type) {
			case 'image':
			case 'favicon':
			case 'icon':
				$this->accept = implode(',', mime_type($this->type));
				break;
			case 'audio':
			case 'video':
			case 'file':
				$this->accept = implode(',', mime_type($this->type));
				$this->recommend = $this->size . ' mb';
				break;
			default:
				$this->accept = implode(',', mime_type('image'));
				$this->recommend = $this->size . ' mb';
				break;
		}
	}
	/**
	 * Get the view / contents that represent the component.
	 */
	public function render(): View|Closure|string
	{
		return view('components.upload.image');
	}
}
