<?php

namespace App\View\Components\Permission;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Collection;

class Choice extends Component
{
	public $pid, $header, $permission, $class, $class_header, $level, $super, $oilpriceAbcChecked;

	public function __construct($pid, $header = '', $permission = [], $class = '', $classHeader = '', $level = 0, $super = false, $oilpriceAbcChecked = [])
	{
		$this->pid = $pid;
		$this->header = $header;
		$this->permission = $permission;
		$this->class = $class;
		$this->class_header = $classHeader;
		$this->level = $level;
		$this->super = $super;
		// Normalize to array in case a Collection or other type is passed
		if ($oilpriceAbcChecked instanceof Collection) {
			$this->oilpriceAbcChecked = $oilpriceAbcChecked->toArray();
		} else if (!is_array($oilpriceAbcChecked)) {
			$this->oilpriceAbcChecked = (array) $oilpriceAbcChecked;
		} else {
			$this->oilpriceAbcChecked = $oilpriceAbcChecked;
		}
	}

	public function render(): View|Closure|string
	{
		return view('components.permission.choice');
	}
}
