<?php

namespace App\View\Components\Form;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Input extends Component
{
    /**
     * Create a new component instance.
     */

    public function __construct(
        public $name,
        public $id = null,
        public $label = null,
        public $class = null,
        public $type = "input",
        public $lang = null,
        public $value = null,
        public $rows = 4,
        public $maxlength = null,
        public $minlength = null,
        public $placeholder = null,
        public $readonly = null,
        public $required = false,
        public $icon = null,
        public $end = null
    ) {
        $this->name = $name . (!empty($lang) ? "_{$lang}" : null);
        $this->id = $id ?? $this->name;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.form.input');
    }
}
