<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class TrackVisitor
{
	/**
	 * Handle an incoming request.
	 *
	 * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
	 */
	public function handle(Request $request, Closure $next): Response
	{
		$ip = ip_address();
		$agent = $request->server('HTTP_USER_AGENT');
		$file = 'assets/json/visitor.json';

		if (File::exists($file)) {
			$data = File::json($file, JSON_UNESCAPED_UNICODE);
			if (!empty($data['exp']) && $data['exp'] < strtotime(now())) {
				$data['exp'] = strtotime('+1 minute');
				$data['visitor'] = [['ip' => $ip, 'agent' => $agent]];

				File::put($file, json_encode($data, JSON_UNESCAPED_UNICODE));
			} else {
				$chk = false;
				foreach ($data['visitor'] as $k => $v) {
					if ($ip == $v['ip'] && $agent == $v['agent']) {
						$chk = true;
						break;
					}
				}

				if (!$chk) {
					$data['visitor'][] = ['ip' => $ip, 'agent' => $agent];
					$data['exp'] = strtotime('+1 minute');
				}

				File::put($file, json_encode($data, JSON_UNESCAPED_UNICODE));
			}
		} else {
			$data = [
				'exp' => strtotime('+1 minute'),
				'visitor' => [
					['ip' => $ip, 'agent' => $agent],
				]
			];

			File::put($file, json_encode($data, JSON_UNESCAPED_UNICODE));
		}

		return $next($request);
	}
}
