<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class HttpAccessLogFile
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $request->marge(['start' => microtime(true)]);

        return $next($request);
    }
    public function terminate($request, $response)
    {
        $request->marge(['end' => microtime(true)]);

        $this->log($request, $response);
    }

    protected function log($request, $response)
    {
        $log  = [
            'ip' => $request->getClientIp(),
            'method' => $request->getMethod(),
            'url' => $request->fullUrl(),
            'duration' => $request->end - $request->start,
            'request_body' => $request->all(),
            'response' => $response->getContent()
        ];
        // Log::info(json_encode($log,JSON_UNESCAPED_UNICODE));
        Log::channel('http')->log('info', json_encode($log, JSON_UNESCAPED_UNICODE));
    }
}
