<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Modules\Member\app\Models\Member;
use Symfony\Component\HttpFoundation\Response;

class CheckStatusLogin
{
	/**
	 * Handle an incoming request.
	 *
	 * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
	 */
	public function handle(Request $request, Closure $next): Response
	{
		if (Auth::guard('member')->check()) {
			$chk = Member::where('id', Auth::guard('member')->user()->id)->first();
			
			// ตรวจสอบสถานะผู้ใช้
			if ($chk->status == 0) {
				Auth::guard('member')->logout();
				Cookie::queue(Cookie::forget('order_uuid'));
				$request->session()->forget('order_uuid');

				return redirect()->route('frontend.login');
			}
			
			// ตรวจสอบสถานะระดับพนักงาน (lavel)
			if (empty($chk->lavel) || empty($chk->lavel->status) || $chk->lavel->status == 0) {
				Auth::guard('member')->logout();
				Cookie::queue(Cookie::forget('order_uuid'));
				$request->session()->forget('order_uuid');

				return redirect()->route('frontend.login')->with('error', 'ระดับพนักงานของคุณถูกปิดการใช้งาน กรุณาติดต่อผู้ดูแลระบบ');
			}
		}

		return $next($request);
	}
}
