<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckSign
{
	/**
	 * Handle an incoming request.
	 *
	 * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
	 */
	public function handle(Request $request, Closure $next): Response
	{
		if (str_contains($request->route()->getName(), 'logout') && !Auth::guard('member')->check())
			return redirect()->route('frontend.login');
		elseif (!str_contains($request->route()->getName(), 'logout') && Auth::guard('member')->check())
			return redirect()->route('frontend.member', ['slug' => 'profile']);

		return $next($request);
	}
}
