<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class CheckLogin
{
	/**
	 * Handle an incoming request.
	 *
	 * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
	 */
	public function handle(Request $request, Closure $next): Response
	{
		$chk = [
			'frontend.signin',
			'frontend.signup',
		];

		if (in_array(Route::currentRouteName(), $chk) && Auth::guard('member')->check())
			return redirect()->route('frontend.index');

		if (Route::currentRouteName() == 'frontend.logout' || Auth::guard('member')->check())
			return $next($request);

		if (!in_array(Route::currentRouteName(), $chk))
			return redirect()->route('frontend.signin', ['redirect' => urlencode($request->fullUrl() ?? '')]);

		return $next($request);
	}
}
