<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
	/**
	 * Get the path the user should be redirected to when they are not authenticated.
	 */
	protected function redirectTo(Request $request)
	{
		if (!$request->expectsJson())
			if ($request->is('admin') || $request->is('admin/*')) {
				return route('admin.login', ['redirect' => $request->fullUrl() ?? '']);
			} elseif ($request->is('api') || $request->is('api/*')) {
				return route('api.login');
			} elseif ($request->is('member') || $request->is('member/*')) {
				return mwz_route('page.login', ['redirect' => $request->fullUrl() ?? '']);
			} else {
				return route('page.login');
			}
	}
}
