<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class TimelineExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		return [
			'ลำดับ',
			'สมาชิก',
			'สถานที่ปัจจุบัน',
			'สถานที่จะไป',
			'ระยะทาง (กม.)',
			'ค่าน้ำมัน (บาท)',
			'วันที่',
			'เช็คอิน',
			'เช็คเอาท์',
			'สถานะ',
		];
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			$this->collection->search($data) + 1,
			$data->member->name ?? '',
			$data->current_place ?? '',
			$data->target_place ?? '',
			$data->distance_km ?? '',
			$data->oil_price ?? '',
			$data->created_at ? $data->created_at->format('d/m/Y') : '',
			$data->time ? $data->time->format('H:i') : '',
			$data->checkout_time ? $data->checkout_time->format('H:i') : '',
			match ($data->status) {
				1 => 'รอส่งคำขอ',
				2 => 'รออนุมัติจาก manager',
				3 => 'รออนุมัติจาก BU',
				4 => 'อนุมัติ',
				13 => 'ไม่อนุมัติ',
				default => '',
			},
		];
	}

	public function columnFormats(): array
	{
		return [
			'G' => NumberFormat::FORMAT_DATE_DDMMYYYY,
			'H' => NumberFormat::FORMAT_DATE_TIME4,
			'I' => NumberFormat::FORMAT_DATE_TIME4,
		];
	}
}

