<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Modules\Order\app\Http\Controllers\OrderController;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class OrderMemberExport implements FromCollection, WithHeadings, WithMapping, WithColumnFormatting, ShouldAutoSize
{
	public $collection;
	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'date',
			'no',
			'name',
			'email',
			'tel',
			'product',
			'price_piece',
			'quantity',
			'total',
			'grand_total',
			'status',
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		$arr = [];
		$date = !empty($data->cart_at) ? str_date($data->cart_at, 'd m Y') : '';
		$no = $data->no ?? '';
		$member = OrderController::get_member_in_order($data);

		foreach ($data->items as $i) {
			$type = '';
			if ($data->type == 'MEMBER')
				$type = __('field.' . strtolower($i->member_history->type ?? '')) . ' (' . __('field.' . strtolower($i->member_type->type ?? '')) . ')';

			$arr = [
				$date,
				$no,
				$member['name'] ?? '',
				$member['email'] ?? '',
				$member['tel'] ?? '',
				$type, // สินค้า
				!empty($i->price) && $i->price != '0.00' ? number_format($i->price, 2) : '',
				$i->qty ?? '',
				!empty($i->total) && $i->total != '0.00' ? number_format($i->total, 2) : '',
				!empty($data->grand_total) && $data->grand_total != '0.00' ? number_format($data->grand_total, 2) : '',
				__('order::status.order.' . strtolower($data->status))
			];
		}

		return $arr;
	}

	public function columnFormats(): array
	{
		return [
			'A' => NumberFormat::FORMAT_DATE_DDMMYYYY,
			'G' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
			'I' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
			'J' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
		];
	}
}
