<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class MemberExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithColumnFormatting
{
	public $collection;
	private $rowNumber = 0;

	public function __construct($collection)
	{
		$this->collection = $collection;
	}

	public function headings(): array
	{
		$header = [
			'no',
			'code',
			'name',
			'email',
			'department',
			'position',
			// 'parent_id',
			'lavel_id',
			'approve_by_first_id',
			'approve_by_second_id',
			'status',
			'created_at',
		];
		$headings = [];

		foreach ($header as $value)
			$headings[] = __('field.' . $value);

		return $headings;
	}

	public function collection()
	{
		return $this->collection;
	}

	public function map($data): array
	{
		return [
			++$this->rowNumber, // ลำดับที่
			$data->code ?? '', // รหัสสมาชิก
			$data->name ?? '', // ชื่อ
			$data->email ?? '', // อีเมล
			$data->department ?? '', // แผนก
			$data->position ?? '', // ตำแหน่ง
			// $data->parent ? ($data->parent->name ?? '') : '', // ผู้บังคับบัญชา
			$data->lavel ? ($data->lavel->name ?? '') : '', // ระดับ
			$data->approve_by_first ? ($data->approve_by_first->name ?? '') : '', // ผู้อนุมัติ 1
			$data->approve_by_second ? ($data->approve_by_second->name ?? '') : '', // ผู้อนุมัติ 2
			isset($data->status) ? ($data->status == 1 ? 'เปิดใช้งาน' : 'ปิดใช้งาน') : '', // สถานะ (0 = ปิดใช้งาน 1 = เปิดใช้งาน)
			$data->created_at ? $data->created_at->format('Y-m-d H:i') : '', // วันที่สร้าง
		];
	}

	public function columnFormats(): array
	{
		return [
			'L' => NumberFormat::FORMAT_DATE_DATETIME, // created_at
		];
	}
}
