$(document).ready(function () {
	// init for user
	initDatatable();

})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	// =========================  master =========================== //
	if ($("#user-datatable").length > 0) {
		var column = [
			{ data: "DT_RowIndex", orderable: true, className: 'text-center' },
			{ data: "name" }, { data: "username" },
		];
		$_config.role && column.push({ data: "role_id", orderable: false });
		column.push(
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);
		$("#user-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/user/list/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) &&
						$(".frm-filter").serializeArray()
							.map(function (x) {
								if (x.name != '_token') d[x.name] = x.value;
							});
				},
			},
			columns: column,
			order: [[1, 'asc']],
			language: $_LANG.datatable,
		});
		init_Table();
	}
};
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#user-datatable").length > 0) && $("#user-datatable").DataTable().ajax.reload(null, bool);
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setUpdateStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/user/list/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/user/list/set_delete",
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();
	var frm = $("#user_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: "/admin/user/list/save",
		type: "POST",
		contentType: false,
		data: frm_data,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		beforeSend: function (xhr) {
			var rules = {
				name: { required: true, maxlength: 255 },
				username: { required: true, maxlength: 255 },
				email: { required: true, email: true, maxlength: 255 },
				password: {
					minlength: 8,
					required: function () { return $("#id").val() == 0 ? true : false; },
				},
				re_password: {
					minlength: 8,
					equalTo: "#password",
					required: function () { return $("#id").val() == 0 ? true : false; },
				},
			};
			var msg = $_LANG.validate.messages;
			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) { mwz_noti("success", resp.msg, (resp.redirect ? (window.location.href = '/admin/user/list') : window.location.reload())); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
}