$(document).ready(function () {
	initDatatable();

	if ($('#period').length > 0) {
		$('#period').change();
	}
})

window.initDatatable = function () {
	if ($(`#${$_name}-datatable`).length > 0) {
		let column = [{ data: "DT_RowIndex", className: 'text-center' }];

		$_config.table.header.forEach((e) => {
			column.push({ data: e.column, orderable: e.orderable, className: e.class ?? '' });
		});
		column.push(
			{ data: "created_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		$(`#${$_name}-datatable`).DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: $_link_datatable,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		});
		init_Table();
	}
}

window.setReloadDataTable = function (bool = false) {
	($(`#${$_name}-datatable`).length) && $(`#${$_name}-datatable`).DataTable().ajax.reload(null, bool);
}