<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
	public function up(): void
	{
		Schema::create('users', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('role_id')->nullable();
			$table->string('name')->nullable();
			$table->string('username')->nullable();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->string('avatar')->nullable();
			$table->string('facebook_id')->nullable();
			$table->string('twitter_id')->nullable();
			$table->string('google_id')->nullable();
			$table->string('line_id')->nullable();
			$table->string('instagram_id')->nullable();
			$table->string('lang')->default('th')->nullable();
			$table->dateTime('login_at')->nullable();
			$table->boolean('status')->default(0)->nullable();
			$table->string('remember_token')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});

		Schema::create('user_activities', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('user_id')->nullable();
			$table->string('route')->nullable();
			$table->string('url')->nullable();
			$table->string('module')->nullable();
			$table->string('page')->nullable();
			$table->string('action')->nullable();
			$table->longText('request')->nullable();
			$table->string('ip')->nullable();
			$table->text('agent')->nullable();
			$table->timestampsTz();
		});

		Schema::create('user_roles', function (Blueprint $table) {
			$table->id();
			$table->string('name')->nullable();
			$table->integer('sequence')->nullable();
			$table->integer('status')->nullable();
			$table->timestampsTz();
		});

		Schema::create('roles_permissions', function (Blueprint $table) {
			$table->integer('role_id')->nullable();
			$table->integer('permission_id')->nullable();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('users');
		Schema::dropIfExists('user_activities');
		Schema::dropIfExists('user_roles');
		Schema::dropIfExists('roles_permissions');
	}
};
