<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\app\Models\Permissions;

class RolesPermissions extends Model
{
	use HasFactory;

	protected $fillable = [
		'role_id',
		'permission_id',
	];
	protected $table = 'roles_permissions';

	public function role()
	{
		return $this->hasOne(Roles::class, 'id', 'role_id');
	}

	public function permission()
	{
		return $this->hasOne(Permissions::class, 'id', 'permission_id');
	}
}
