<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\app\Models\Permissions;
use Modules\OilPrice\app\Models\OilpriceAbc;

class Roles extends Model
{
	use HasFactory;

	protected $fillable = [
		'name',
		'sequence',
		'status',
	];
	protected $table = 'user_roles';
	protected $primaryKey = 'id';

	public function permissions()
	{
		return $this->hasManyThrough(Permissions::class, RolesPermissions::class, 'role_id', 'id', 'id', 'permission_id');
	}

	public function oilprice_abc()
	{
		return $this->hasMany(OilpriceAbc::class, 'role_id', 'id');
	}

	public function list()
	{
		return $this->belongsToMany(Permissions::class, 'roles_permissions', 'role_id', 'permission_id');
	}
}
