<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Activities extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'user_id',
		'route',
		'url',
		'module',
		'page',
		'action',
		'request',
		'ip',
		'agent',
	];
	protected $table = 'user_activities';
	protected $primaryKey = 'id';

	public function user()
	{
		return $this->hasOne(Users::class, 'id', 'user_id');
	}
}
