<?php

namespace Modules\User\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\User\app\Models\Users;

class UserAdminController extends AdminController
{
	private  $config = ['role' => true,  'api' => false, 'multi' => false], $action;
	//  * Dev : Petch
	//  * Update Date : 21 Jan 2025
	//  */
	public function __construct()
	{
		$routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->action = $explode[3] ?? '';
		} else {
			$this->action = '';
		}

		self::$navbar = [
			['name' => __('user::user.title'), 'url' => null],
			['name' => __('user::user.name'), 'url' => $this->config['multi'] ? route_has('admin.user.user.index') : null]
		];
	}

	/**
	 * Function : index
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function index()
	{
		return view('user::user.index', ['config' => $this->config, 'navbar' => self::$navbar]);
	}

	/**
	 * Function : datatable ajax
	 * Dev : Petch
	 * Update Date :21 Jan 2025
	 */
	public function datatable_ajax(Request $request)
	{
		if ($request->ajax()) {
			//init datatable
			$dt_column = array('id', 'name', 'username', 'updated_at');
			if (!empty($this->config['role'])) {
				$dt_column[] = 'role_id';
			}
			$dt_column[] = 'updated_at';
			$dt_order = $request->get('order')[0]['column'];
			$dt_dir = $request->get('order')[0]['dir'];
			$dt_start = $request->get('start');
			$dt_length = $request->get('length');
			$dt_search = $request->get('search')['value'];
			$dt_filter = $request->get('filter');

			// create user object 
			$req = new Users();

			// add search query if have search from datable
			if (!empty($dt_search)) {
				$req = $req->where(function ($query) use ($dt_search) {
					$query->orWhere('name', 'like', "%" . $dt_search . "%")
						->orWhere('email', 'like', "%" . $dt_search . "%")
						->orWhere('username', 'like', "%" . $dt_search . "%");
				});
			}

			if (!empty($dt_filter['role_id']))
				$req = $req->where('role_id', $dt_filter['role_id']);

			$dt_total = $req->count();
			// set query order & limit from datatable
			$resp = $req->orderBy($dt_column[$dt_order], $dt_dir)
				->offset($dt_start)->limit($dt_length)->get();

			// prepare datatable for resonse
			$tables = datatables($resp)
				->addIndexColumn()
				->setRowId('id')
				->setRowClass('user_row')
				->setTotalRecords($dt_total)
				->setFilteredRecords($dt_total)
				->setOffset($dt_start)
				->editColumn('updated_at', function ($record) {
					return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->updated_at)));
				})
				->editColumn('role_id', function ($record) {
					return $record->role->name ?? '';
				})
				->addColumn('action', function ($record) {
					$user = auth('admin')->user();
					$btn = '<div class="button-list">';
					if ($user->id == 1) {
						if ($record->id != 1)
							$btn .= self::user_status($record->id, 'setUpdateStatus', $record->status);
						if (!empty($record->id))
							$btn .= self::user_route('admin.user.user.edit', $record->id);
						if ($record->id != 1)
							$btn .= self::user_delete($record->id, 'setDelete');
					} else if ($record->id != 1) {
						$chk_edit = mwz_roles('admin.user.user.edit');
						$chk_add = mwz_roles('admin.user.user.add');

						if ($record->id != $user->id && $chk_edit)
							$btn .= $this->user_status($record->id, 'setUpdateStatus', $record->status);

						if ($record->id == $user->id || ($record->id != $user->id && $chk_edit))
							$btn .= $this->user_route('admin.user.user.edit', $record->id);
						else
							$btn .= $this->user_route('admin.user.user.view', $record->id, 'fe-eye');

						if ($record->id != $user->id && $chk_edit && $chk_add)
							$btn .= $this->user_delete($record->id, 'setDelete');
					}
					$btn .= '</div>';
					return $btn;
				})
				->escapeColumns([]);
			// response datatable json
			return $tables->make(true);
		}
	}

	/**
	 * Function : form
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public function form($id = null)
	{
		self::$navbar[] =  ['name' => __("action.{$this->action}"), 'url' => null];

		$data = [];
		if (!empty($id))
			$data = Users::find($id);

		return view('user::user.form', [
			'data' => $data,
			'config' => $this->config,
			'navbar' => self::$navbar,
			'action' => $this->action
		]);
	}

	/**
	 * Function : save
	 * Dev : Petch
	 * Update Date : 4 Feb 2024
	 */
	public function save(Request $request)
	{
		$rule = [
			'name' => 'required|max:255',
		];

		if (!empty($this->config['role']))
			$rule['role_id'] = 'required';
		if (empty($request->get('id'))) {
			$rule['username'] = 'required|max:255';
			$rule['password'] = 'required|max:255';
			$rule['email'] = 'required|email|max:255';
		}
		$msg = [
			'role_id.*' => __('user::user.field.role_placeholder'),
			'name.required' => __('user::user.field.name_placeholder'),
			'name.max' => __('user::user.field.name_max', ['max' => 255]),
			'username.required' => __('user::user.field.username_placeholder'),
			'username.max' => __('user::user.field.username_max', ['max' => 255]),
			'password.*' => __('user::user.field.password_placeholder'),
			'email.*' => __('user::user.field.email_placeholder'),
			'email.max' => __('user::user.field.email_max', ['max' => 255]),
		];
		$valid = validator($request->all(), $rule, $msg);
		if ($valid->fails())
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 303);

		if (empty($request->get('id'))) {
			if (!ctype_alnum($request->get('username')))
				return self::response(['msg' => 'ชื่อ ต้องเป็นตัวอักษรหรือตัวเลขเท่านั้น'], 302);
			elseif (Users::where('username', $request->get('username'))->count() > 0)
				return self::response(['msg' => 'มีชื่อ ในผู้ดูแลระบบนี้แล้ว'], 302);
			else if (Users::where('email', $request->get('email'))->count() > 0)
				return self::response(['msg' => 'มีอีเมล ในผู้ดูแลระบบนี้แล้ว'], 302);
		}

		$attr = [
			"role_id" => $request->get('role_id'),
			"name" => $request->get('name'),
			"email" => $request->get('email'),
			"lang" => $request->get('lang') ?? 'th',
			"status" => $request->get('status') ?? 0,
		];

		if (!empty($request->get('id'))) {
			if (!empty($request->get('password')) && $request->get('password') != '********')
				$attr["password"] = Hash::make($request->get('password'));
		} else {
			$attr['username'] = $request->get('username');
			$attr['password'] = Hash::make($request->get('password'));
		}

		if (check_file_upload($request, 'avatar', 'image'))
			return $this->response(['msg' => "Image " . __('noti.mime_image')], 404);
		$attr['avatar'] = self::set_image_upload($request, 'avatar', "public/user", "avatar_");

		$set = Users::updateOrCreate(['id' => $request->get('id')], $attr);
		if ($set->save())
			return self::response(['msg' => __('noti.success'),'redirect' => ($this->config['multi'] && mwz_roles('admin.user.user.index') || Auth::guard('admin')->user()->id == 1)], 200);

		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function : set status
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function set_status(Request $request)
	{
		$set = Users::find($request->get('id'));
		$set->status = !$set->status;
		if ($set->save()) {
			return self::response(['msg' => __('noti.success'),], 200);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function : delete
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function set_delete(Request $request)
	{
		$set = Users::find($request->get('id'));
		if ($set->delete()) {
			return self::response(['msg' => __('noti.delete'),], 200);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}
}
