<?php

namespace Modules\User\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Modules\User\app\Models\RolesPermissions;
use Modules\User\app\Models\Users;

class RoleController extends Controller
{
	/**
	 * Function : valid route
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	private static function valid_route($id, $route): bool
	{
		$perm = RolesPermissions::where('role_id', $id)
			->where(function ($q) use ($route) {
				$q->whereRelation('role', 'status', 1)
					->whereRelation('permission', 'route_name', $route);
			})->first();

		return !empty($perm);
	}

	/**
	 * Function : valid group
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	private static function valid_group($id, $module, $group): bool
	{
		$perm = RolesPermissions::where('role_id', $id)
			->whereHas('permission', function ($q) use ($module, $group) {
				$q->where([['group', $group], ['module', $module]]);
			})->first();
		return !empty($perm) ? true : false;
	}

	/**
	 * Function : allow route
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public static function allow_route(string $route = null, $id = null): bool
	{
		$route = $route ?? Route::currentRouteName();
		$user = !empty($id) ? Users::find($id) : Auth::guard('admin')->user();
		$chk = false;

		if (str_contains($route, 'admin.menu.menu.'))
			$route = str_replace('admin.menu.menu.', 'admin.menu.group.', $route);

		if (!empty($route)) {
			if ($user->id == 1 || self::valid_route($user->role_id, $route))
				$chk = true;
			elseif (last(explode('.', $route)) == 'save' && self::valid_route($user->role_id, str_replace('save', 'edit', $route)))
				$chk = true;
			elseif (last(explode('.', $route)) == 'set_gallery' && self::valid_route($user->role_id, str_replace('set_gallery', 'add', $route)))
				$chk = true;
		}

		return $chk;
	}

	/**
	 * Function : allow
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public static function allow(string $route = null, $group = 'view', $id = null): bool
	{
		$module = '';
		$user = !empty($id) ? Users::find($id) : Auth::guard('admin')->user();
		$route = $route ?? Route::currentRouteName();

		if (str_contains($route, 'admin.menu.menu.'))
			$route = str_replace('admin.menu.menu.', 'admin.menu.group.', $route);

		if ($route == '') {
			if (!empty($user)) {
				if ($user->id == 1)
					return true;
				if (!empty($route))
					$module = explode('.', $route)[1] ?? null;
				if (!empty($module))
					return self::valid_group($user->role_id, $module, $group);
			}
		}

		return false;
	}
}
