<?php

namespace Modules\User\app\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UserLogin
{
    use SerializesModels, Dispatchable;

    public $user, $action = 'login';
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        // return [];
        return new PrivateChannel('user-login');
    }
}
