import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-setting',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-setting',
			input: [
				__dirname + '/resources/assets/sass/app.scss',
				__dirname + '/resources/assets/js/error.js',
				__dirname + '/resources/assets/js/language.js',
				__dirname + '/resources/assets/js/smtp.js',
				__dirname + '/resources/assets/js/robot.js',
				__dirname + '/resources/assets/js/setting.js',
				__dirname + '/resources/assets/js/tag.js',
			],
			refresh: true,
		}),
	],
});

//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];