<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	Route::prefix('setting')->group(function () {
		Route::get('/', 'SettingAdminController@form')->name('admin.setting.setting.index');
		Route::post('/save', 'SettingAdminController@save')->name('admin.setting.setting.edit');
	});
	Route::prefix('tag')->group(function () {
		Route::get('/', 'TagAdminController@index')->name('admin.setting.tag.index');
		Route::get('/datatable_ajax', 'TagAdminController@datatable_ajax')->name('admin.setting.tag.datatable_ajax');

		Route::get('/add', 'TagAdminController@form')->name('admin.setting.tag.add');
		Route::get('/edit/{id}', 'TagAdminController@form')->name('admin.setting.tag.edit');
		Route::get('/view/{id}', 'TagAdminController@form')->name('admin.setting.tag.view');
		Route::post('/save', 'TagAdminController@save')->name('admin.setting.tag.save');

		Route::post('/set_status', 'TagAdminController@set_status')->name('admin.setting.tag.set_status');
		Route::post('/set_delete', 'TagAdminController@set_delete')->name('admin.setting.tag.set_delete');
	});
	Route::prefix('languages')->group(function () {
		Route::get('/', 'LanguagesAdminController@index')->name('admin.setting.language.index');
		Route::get('/datatable_ajax', 'LanguagesAdminController@datatable_ajax')->name('admin.setting.language.datatable_ajax');

		Route::get('/add', 'LanguagesAdminController@form')->name('admin.setting.language.add');
		Route::get('/edit/{id}', 'LanguagesAdminController@form')->name('admin.setting.language.edit');
		Route::post('/save', 'LanguagesAdminController@save')->name('admin.setting.language.save');

		Route::post('/set_default', 'LanguagesAdminController@set_default')->name('admin.setting.language.set_default');
		Route::post('/set_status', 'LanguagesAdminController@set_status')->name('admin.setting.language.set_status');
		Route::post('/set_delete', 'LanguagesAdminController@set_delete')->name('admin.setting.language.set_delete');

		Route::post('/get_list', 'LanguagesAdminController@get_list')->name('admin.setting.language.get_list');
		Route::post('/get_code', 'LanguagesAdminController@get_code')->name('admin.setting.language.get_code');
	});

	Route::prefix('error')->group(function () {
		Route::get('/', 'ErrorAdminController@index')->name('admin.setting.error.index');
		Route::get('/datatable_ajax', 'ErrorAdminController@datatable_ajax')->name('admin.setting.error.datatable_ajax');

		Route::get('/add', 'ErrorAdminController@form')->name('admin.setting.error.add');
		Route::get('/edit/{id?}', 'ErrorAdminController@form')->name('admin.setting.error.edit');
		Route::post('/save', 'ErrorAdminController@save')->name('admin.setting.error.save');
	});

	Route::prefix('smtp')->group(function () {
		Route::get('/', 'SMTPAdminController@form')->name('admin.setting.smtp.index');
		Route::post('/save', 'SMTPAdminController@save')->name('admin.setting.smtp.save');

		Route::get('test/line', 'SMTPAdminController@line')->name('admin.setting.smtp.line');
		Route::get('test/email', 'SMTPAdminController@email')->name('admin.setting.smtp.email');
	});

	Route::prefix('robot')->group(function () {
		Route::get('/', 'RobotAdminController@form')->name('admin.setting.robot.index');
		Route::post('/save', 'RobotAdminController@save')->name('admin.setting.robot.edit');
	});
	Route::prefix('file')->group(function () {
		Route::get('/', 'FilemanagerController@index')->name('admin.setting.filemanager.index');
	});
});


Route::group(['middleware' => 'setlocale'], function () {
	Route::get('error/{code?}', 'ErrorController@error')->name('error.page');
});
Route::group(['prefix' => '{locale?}', 'where' => ['locale' => '[a-zA-Z]{2}'], 'middleware' => 'setlocale'], function () {
	Route::get('error/{code?}', 'ErrorController@error')->name('lang.error.page');
});
