@extends('form.app')

@section('styles')
@endsection

@section('content')
    @includeIf('setting::smtp.form.navbar')
    @if (session()->has('errors'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button class="btn-close" data-bs-dismiss="alert" type="button" aria-label="Close"></button>
            {{ session('errors') }}
        </div>
        <?php Session::forget('errors'); ?>
    @endif
    <form class="row" id="smtp_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="col-md-12">
            <div class="tab-content">
                <div class="tab-pane active" id="line">
                    @includeIf('setting::smtp.form.line')
                </div>
                <div class="tab-pane" id="email">
                    @includeIf('setting::smtp.form.email')
                </div>
            </div>
        </div>
    </form>
@endsection

@section('scripts')
    {{ module_vite('build-setting', 'resources/assets/js/smtp.js') }}
@endsection
