@extends('error.app')

@section('styles')
@endsection

@section('content')
    <?php $setting = setting(); ?>

    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="text-center p-2">
                <img class="mx-auto" src="{{ check_file($setting->logo_header ?? '', asset('assets/images/logo-alt.png')) }}" height="60">
            </div>
            <div class="card card-body  my-3 p-4">
                <div class="text-center">
                    <h1 class="text-error">{{ $data->code ?? 404 }}</h1>
                    <h3 class="mt-3 mb-2">{{ $data->local->title ?? '' }}</h3>
                    <div class="text-muted mb-3">{!! mwz_getTextString($data->local->desc ?? '') !!}</div>
                    <button class="btn btn-danger waves-effect" onclick="history.back()">{{ __('action.back') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    {{ module_vite('build-setting', 'resources/assets/js/robot.js') }}
@endsection
