/**
* Function : Save
* Dev : Petch
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	let frm = $("#smtp_frm");
	let frm_data = new FormData($(frm)[0]);

	$.ajax({
		url: `/admin/smtp/save`,
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate form
			const field = ['line_token', 'email_host', 'email_port', 'email_username', 'email_password', 'email_encryption', 'email_address', 'email_name'];
			const rules = [], msg = [];
			$.each(field, function (index, ele) {
				rules[ele] = { required: true, maxlength: 255 };
				msg[ele] = { required: $(`[name="${ele}"]`).attr('placeholder') };
			});
			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) {
			mwz_noti("success", resp.msg, window.location.reload());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};