
$(document).ready(function () {
	// init for tag
	initDatatable();
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	// =========================  tag =========================== //
	if ($("#language-datatable").length > 0) {
		$("#language-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/languages/datatable_ajax",
			},
			columns: [
				{ data: "code", orderable: true, className: 'text-center' },
				{ data: "flag", orderable: false, className: 'text-center' },
				{ data: "name" },
				{ data: "updated_at" },
				{ data: "action", orderable: false, className: 'text-center' },
			],
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : set Reload DataTable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	$("#language-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();
	var frm = $("#language_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: "/admin/languages/save",
		type: "POST",
		contentType: false,
		data: frm_data,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = {
				code: { required: true },
				name: { required: true },
			};

			var msg = {
				code: { required: $(frm).find('[name="code"]').data('placeholder') },
				name: { required: $(frm).find('[name="name"]').attr('placeholder') },
			};

			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) { mwz_noti("success", resp.msg, window.location.replace("/admin/languages/")) },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/languages/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	})
}
/**
* Function : set Default
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDefault = function (id) {
	event.preventDefault();
	$.ajax({
		url: '/admin/languages/set_default',
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	})
};