$(document).ready(function () {
	// init for page
	initDatatable();

})
/**
* Function : Init Datatable
* Dev : Petch 
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	// =========================  master =========================== //
	if ($("#error-datatable").length > 0) {
		$("#error-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/error/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: [
				{ data: "DT_RowIndex", className: 'text-center' },
				{ data: "code", orderable: true, className: 'text-center' },
				{ data: "name", orderable: false },
				{ data: "updated_at", orderable: true },
				{ data: "action", orderable: false, className: 'text-center' },
			],
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : Save
* Dev : Petch 
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	var frm = $("#error_frm");
	var frm_data = new FormData($(frm)[0]);

	$.ajax({
		url: "/admin/error/save",
		type: "POST",
		contentType: false,
		data: frm_data,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		beforeSend: function (xhr) {
			var rules = [];
			var msg = [];
			$.each($_lang, function (i, lang) {
				rules[`title_${lang}`] = { required: true, maxlength: 255 };
				msg[`title_${lang}`] = { required: $(frm).find(`[name="title_${lang}"]`).attr('placeholder') };
				rules[`desc_${lang}`] = { required: true };
				msg[`desc_${lang}`] = { required: $(frm).find(`[name="desc_${lang}"]`).attr('placeholder') };
			});
			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));

		},
		success: function (resp) {
			mwz_noti("success", resp.msg, window.location.replace("/admin/error"));
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
}
/**
* Function : Reload DataTable
* Dev : Petch 
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	$("#error-datatable").DataTable().ajax.reload(null, bool);
};