<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up()
	{
		Schema::create('setting', function (Blueprint $table) {
			$table->id();
			$table->string('logo_header')->nullable();
			$table->string('logo_footer')->nullable();
			$table->string('seo_image')->nullable();
			$table->string('gtag')->nullable();
			$table->string('recapcha')->nullable();
			$table->timestamps();
		});

		Schema::create('setting_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('setting_id');
			$table->string('lang')->nullable();
			$table->string('copy_right')->nullable();
			$table->timestamps();
		});

		Schema::create('setting_tags', function (Blueprint $table) {
			$table->id();
			$table->text('type')->nullable();
			$table->text('head')->nullable();
			$table->text('body')->nullable();
			$table->text('footer')->nullable();
			$table->text('status')->nullable();
			$table->timestamps();
		});

		Schema::create('setting_language', function (Blueprint $table) {
			$table->id();
			$table->string('flag')->nullable();
			$table->string('code')->nullable();
			$table->string('name')->nullable();
			$table->integer('sequence')->nullable();
			$table->boolean('default')->default(0)->nullable();
			$table->boolean('status')->default(0)->nullable();
			$table->timestamps();
		});

		Schema::create('errors', function (Blueprint $table) {
			$table->id();
			$table->string('code')->nullable();
			$table->tinyInteger('status')->nullable()->default(1);
			$table->timestamps();
		});

		Schema::create('errors_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('error_id');
			$table->string('lang')->nullable();
			$table->string('title')->nullable();
			$table->text('desc')->nullable();
			$table->timestamps();
		});

		Schema::create('setting_smtp', function (Blueprint $table) {
			$table->id();
			$table->string('line_token')->nullable();
			$table->tinyInteger('line_status')->nullable()->default(0);
			$table->string('email_host')->nullable();
			$table->string('email_port')->nullable();
			$table->string('email_username')->nullable();
			$table->string('email_password')->nullable();
			$table->string('email_encryption')->nullable();
			$table->string('email_address')->nullable();
			$table->string('email_name')->nullable();
			$table->tinyInteger('email_status')->nullable()->default(0);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('setting');
		Schema::dropIfExists('setting_translate');
		Schema::dropIfExists('setting_tags');
		Schema::dropIfExists('setting_smtp');
		Schema::dropIfExists('setting_language');
		Schema::dropIfExists('errors_translate');
		Schema::dropIfExists('errors');
		Schema::dropIfExists('setting_notification');
	}
};
