<?php

namespace Modules\Setting\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
	use HasFactory;

	protected $fillable = [
		'logo_header',
		'logo_footer',
		'seo_image',
		'gtag',
		'recapcha',
	];
	protected $table = "setting";

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
		});
	}

	public function langs()
	{
		return $this->hasMany(SettingTranslate::class, 'setting_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(SettingTranslate::class, 'setting_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'))->select(['copy_right']);
	}
}
