<?php

namespace Modules\Setting\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\Setting\app\Models\Errors;

class ErrorController extends Controller
{
    /**
     * Function : error page
     * Dev : Poom
     * Update Date : 18 Apr 2024
     * @param \Illuminate\Http\Request $request
     */
    public function error()
    {
        $data = [];
        $code = request('code');
        if (!empty($code)) {
            $data = Errors::where('code', $code)->first();
        }
        if (empty($data)) {
            $data = Errors::where('code', 404)->first();
        }

        return view('setting::error.page.index', ['data' => $data]);
    }
}
