<?php

use Illuminate\Support\Facades\Route;
use Modules\Policy\app\Http\Controllers\PolicyController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	Route::prefix('policy')->group(function () {
		Route::prefix('privacy')->group(function () {
			Route::get('/', 'PolicyAdminController@index')->name('admin.policy.privacy.index');
			Route::post('/save', 'PolicyAdminController@save')->name('admin.policy.privacy.edit');
		});
		Route::prefix('term')->group(function () {
			Route::get('/', 'TermAdminController@index')->name('admin.policy.term.index');
			Route::post('/save', 'TermAdminController@save')->name('admin.policy.term.save');
		});
		Route::prefix('marketing')->group(function () {
			Route::get('/', 'MarketingAdminController@index')->name('admin.policy.marketing.index');
			Route::post('/save', 'MarketingAdminController@save')->name('admin.policy.marketing.save');
		});
		Route::prefix('logs')->group(function () {
			Route::get('/', 'AcceptAdminController@index')->name('admin.policy.logs.index');
			Route::get('/datatable_ajax', 'AcceptAdminController@datatable_ajax')->name('admin.policy.logs.datatable_ajax');
		});
	});
	// Route::prefix('cookies')->group(function () {
	// 	Route::prefix('list')->group(function () {
	// 		Route::get('/', 'CookiesAdminController@index')->name('admin.cookies.list.index');
	// 		Route::get('/datatable_ajax', 'CookiesAdminController@datatable_ajax')->name('admin.cookies.list.datatable_ajax');

	// 		Route::get('/edit/{id}', 'CookiesAdminController@form')->name('admin.cookies.list.edit');
	// 		Route::post('/save', 'CookiesAdminController@save')->name('admin.cookies.list.save');

	// 		Route::post('/set_default', 'CookiesAdminController@set_default')->name('admin.cookies.list.set_default');
	// 		Route::post('/set_status', 'CookiesAdminController@set_status')->name('admin.cookies.list.set_status');
	// 		Route::post('/set_sort', 'CookiesAdminController@set_sort')->name('admin.cookies.list.set_sort');
	// 	});
	// 	Route::prefix('logs')->group(function () {
	// 		Route::get('/', 'CookiesLogAdminController@index')->name('admin.cookies.logs.index');
	// 		Route::get('/datatable_ajax', 'CookiesLogAdminController@datatable_ajax')->name('admin.cookies.logs.datatable_ajax');
	// 	});
	// });
});



Route::middleware(['apiLocale'])->prefix('api/v1')->name('api.')->group(function () {
	Route::prefix('pdpa')->name('pdpa.')->group(function () {
		Route::post('/save', [PolicyController::class, 'save'])->name('save');
	});
});
