@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('policy::policy.form.navbar')

    <?php $input = $config['input']; ?>
    <?php $content = $config['content']; ?>

    <form class="row" id="policy_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                <div class="tab-pane active" id="info">
                    @includeIf('policy::policy.form.translates')
                </div>
                {{-- <div class="tab-pane" id="cookies">
                    @includeIf('policy::policy.form.setting')
                </div> --}}
                @if (!empty($config['seo']))
                    <div class="tab-pane" id="meta">
                        @includeIf('mwz::seo.form')
                    </div>
                @endif
            </div>
        </div>
        <div class="col-lg-3">
            <x-form.lang />
            {{-- @includeIf('policy::policy.form.status') --}}
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
    </script>
    {{ module_vite('build-policy', 'resources/assets/js/policy.js') }}
@endsection
