@extends('form.app')

@section('styles')
@endsection

@section('content')
    {{-- navbar --}}
    @includeIf('policy::cookies.form.navbar')

    <form class="row" id="cookies_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                <div class="tab-pane active" id="info">
                    @includeIf('policy::cookies.form.translates')
                </div>
                <div class="tab-pane" id="image">
                    <div class="card card-body">
                        <x-upload.image id="1" name="image" type="image" label="{{ __('policy::cookies.field.image') }}" image="{{ $data->image ?? null }}" recommend="{{ __('policy::cookies.field.image_placeholder') }}" />
                    </div>
                </div>
                @if (!empty($config['seo']))
                    <div class="tab-pane" id="meta">
                        @includeIf('mwz::seo.form')
                    </div>
                @endif
            </div>
        </div>
        <div class="col-lg-3">
            <x-form.lang />
            @includeIf('policy::cookies.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        var $_config = $.parseJSON('<?= json_encode($config) ?>');
    </script>
    {{ module_vite('build-policy', 'resources/assets/js/cookies.js') }}
@endsection
