
$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#cookies-datatable").length > 0) {
		var column = [
			{ data: "DT_RowIndex", className: 'text-center' },
			{ data: "code", orderable: true }
		];
		($_config.input.name.status) &&
			column.push({ data: "name", orderable: false });
		column.push(
			{ data: "sort", orderable: false, className: 'text-center' },
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);
		$("#cookies-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/cookies/list/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		});
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#cookies-datatable").length > 0) &&
		$("#cookies-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Set Default
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDefault = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/cookies/list/set_default",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	})
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/cookies/list/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	})
};
/**
* Function : Sort Item
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSort = function (id, move) {
	event.preventDefault();
	$.ajax({
		url: "/admin/cookies/list/set_sort",
		type: "POST",
		data: { id: id, move: move },
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		success: function (resp) { setReloadDataTable(); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	($_config.seo) && mwzGenerateMatadata(0);

	var frm = $("#cookies_frm");
	var frm_data = new FormData($(frm)[0]);

	$.ajax({
		url: '/admin/cookies/list/save',
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = [], msg = [];
			$.each($_lang, function (i, lang) {
				rules[`name_${lang}`] = { required: true, maxlength: 255 };
				msg[`name_${lang}`] = { required: $(`[name="name_${lang}"]`).attr('placeholder') };
			});
			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		}, success: function (resp) {
			mwz_noti("success", resp.msg, window.location.replace("/admin/cookies/list/"));
		}, error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};