
$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#accept-datatable").length > 0) {
		$("#accept-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/policy/logs/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: [
				{ data: "DT_RowIndex", className: 'text-center' },
				{ data: "ip" },
				{ data: "agent" },
				{ data: "status", orderable: false },
				{ data: "created_at" },
			],
			language: $_LANG.datatable,
		});
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#accept-datatable").length > 0) &&
		$("#accept-datatable").DataTable().ajax.reload(null, bool);
}
