<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up(): void
	{
		Schema::create('policy', function (Blueprint $table) {
			$table->id();
			$table->tinyInteger('status')->default(0)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		Schema::create('policy_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('policy_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->string('title')->nullable();
			$table->text('text')->nullable();
			$table->longText('body')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		Schema::create('term', function (Blueprint $table) {
			$table->id();
			$table->tinyInteger('status')->default(0)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		Schema::create('term_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('term_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		// Schema::create('marketing', function (Blueprint $table) {
		// 	$table->id();
		// 	$table->tinyInteger('status')->default(0)->nullable();
		// 	$table->softDeletes();
		// 	$table->timestamps();
		// });
		// Schema::create('marketing_translate', function (Blueprint $table) {
		// 	$table->id();
		// 	$table->unsignedBigInteger('marketing_id')->nullable();
		// 	$table->string('lang')->nullable();
		// 	$table->string('name')->nullable();
		// 	$table->text('desc')->nullable();
		// 	$table->longText('detail')->nullable();
		// 	$table->softDeletes();
		// 	$table->timestamps();
		// });
		// Schema::create('cookies', function (Blueprint $table) {
		// 	$table->id();
		// 	$table->string('code')->nullable();
		// 	$table->integer('sequence')->nullable();
		// 	$table->tinyInteger('default')->default(0)->nullable();
		// 	$table->tinyInteger('status')->default(0)->nullable();
		// 	$table->softDeletes();
		// 	$table->timestamps();
		// });
		// Schema::create('cookies_translate', function (Blueprint $table) {
		// 	$table->id();
		// 	$table->unsignedBigInteger('cookie_id')->nullable();
		// 	$table->string('lang')->nullable();
		// 	$table->string('name')->nullable();
		// 	$table->text('desc')->nullable();
		// 	$table->longText('detail')->nullable();
		// 	$table->softDeletes();
		// 	$table->timestamps();
		// });

		Schema::create('accepts_log', function (Blueprint $table) {
			$table->id();
			$table->integer('policy_id')->index();
			$table->integer('member_id')->nullable();
			$table->string('ip')->nullable();
			$table->text('agent')->nullable();
			$table->tinyInteger('status')->nullable();
			$table->timestamps();
		});

		// Schema::create('cookies_log', function (Blueprint $table) {
		// 	$table->id();
		// 	$table->integer('policy_id')->index();
		// 	$table->integer('member_id')->index();
		// 	$table->string('ip')->nullable();
		// 	$table->text('agent')->nullable();
		// 	$table->tinyInteger('ad_storage')->nullable();
		// 	$table->tinyInteger('ad_user_data')->nullable();
		// 	$table->tinyInteger('ad_personalization')->nullable();
		// 	$table->tinyInteger('analytics_storage')->nullable();
		// 	$table->timestamps();
		// });
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('policy_translate');
		Schema::dropIfExists('policy');
		Schema::dropIfExists('term_translate');
		Schema::dropIfExists('term');
		// Schema::dropIfExists('cookies_translate');
		// Schema::dropIfExists('cookies');
		// Schema::dropIfExists('marketing_translate');
		// Schema::dropIfExists('marketing');
		Schema::dropIfExists('accepts_log');
		// Schema::dropIfExists('cookies_log');
	}
};
