<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Policy\Database\factories\TermFactory;

class Term extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['id', 'status', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "term";
    protected $primaryKey = "id";

    protected static function newFactory(): TermFactory
    {
        return TermFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(TermTranslate::class, 'term_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(TermTranslate::class, 'term_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
}
