<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Policy\Database\factories\PolicyTranslateFactory;

class PolicyTranslate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['id', 'policy_id', 'lang', 'name', 'desc', 'detail', 'title', 'text', 'body', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "policy_translate";
    protected $primaryKey = "id";

    protected static function newFactory(): PolicyTranslateFactory
    {
        return PolicyTranslateFactory::new();
    }
}
