<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Policy\Database\factories\CookiesLogFactory;

class CookiesLog extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'policy_id', 'member_id', 'ip', 'agent', 'ad_storage', 'ad_user_data', 'ad_personalization', 'analytics_storage', 'created_at', 'updated_at'];
    protected $table = "cookies_log";
    protected $primaryKey = "id";

    protected static function newFactory(): CookiesLogFactory
    {
        return CookiesLogFactory::new();
    }
}
